/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.KeyValueSerializer;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.SimpleStatsExtractor;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.KeyValueDataFileWriter;
import org.apache.paimon.io.RollingFileWriter;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.statistics.SimpleColStatsCollector;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.StatsCollectorFactories;

public class KeyValueFileWriterFactory {
    private final FileIO fileIO;
    private final long schemaId;
    private final RowType keyType;
    private final RowType valueType;
    private final WriteFormatContext formatContext;
    private final long suggestedFileSize;
    private final CoreOptions options;

    private KeyValueFileWriterFactory(FileIO fileIO, long schemaId, RowType keyType, RowType valueType, WriteFormatContext formatContext, long suggestedFileSize, CoreOptions options) {
        this.fileIO = fileIO;
        this.schemaId = schemaId;
        this.keyType = keyType;
        this.valueType = valueType;
        this.formatContext = formatContext;
        this.suggestedFileSize = suggestedFileSize;
        this.options = options;
    }

    public RowType keyType() {
        return this.keyType;
    }

    public RowType valueType() {
        return this.valueType;
    }

    @VisibleForTesting
    public DataFilePathFactory pathFactory(int level) {
        return this.formatContext.pathFactory(level);
    }

    public RollingFileWriter<KeyValue, DataFileMeta> createRollingMergeTreeFileWriter(int level, FileSource fileSource) {
        return new RollingFileWriter<KeyValue, DataFileMeta>(() -> this.createDataFileWriter(this.formatContext.pathFactory(level).newPath(), level, fileSource), this.suggestedFileSize);
    }

    public RollingFileWriter<KeyValue, DataFileMeta> createRollingChangelogFileWriter(int level) {
        return new RollingFileWriter<KeyValue, DataFileMeta>(() -> this.createDataFileWriter(this.formatContext.pathFactory(level).newChangelogPath(), level, FileSource.APPEND), this.suggestedFileSize);
    }

    private KeyValueDataFileWriter createDataFileWriter(Path path, int level, FileSource fileSource) {
        KeyValueSerializer kvSerializer = new KeyValueSerializer(this.keyType, this.valueType);
        return new KeyValueDataFileWriter(this.fileIO, this.formatContext.writerFactory(level), path, kvSerializer::toRow, this.keyType, this.valueType, this.formatContext.extractor(level), this.schemaId, level, this.formatContext.compression(level), this.options, fileSource);
    }

    public void deleteFile(String filename, int level) {
        this.fileIO.deleteQuietly(this.formatContext.pathFactory(level).toPath(filename));
    }

    public void copyFile(String sourceFileName, String targetFileName, int level) throws IOException {
        Path sourcePath = this.formatContext.pathFactory(level).toPath(sourceFileName);
        Path targetPath = this.formatContext.pathFactory(level).toPath(targetFileName);
        this.fileIO.copyFile(sourcePath, targetPath, true);
    }

    public FileIO getFileIO() {
        return this.fileIO;
    }

    public Path newChangelogPath(int level) {
        return this.formatContext.pathFactory(level).newChangelogPath();
    }

    public static Builder builder(FileIO fileIO, long schemaId, RowType keyType, RowType valueType, FileFormat fileFormat, Map<String, FileStorePathFactory> format2PathFactory, long suggestedFileSize) {
        return new Builder(fileIO, schemaId, keyType, valueType, fileFormat, format2PathFactory, suggestedFileSize);
    }

    private static class WriteFormatContext {
        private final Function<Integer, String> level2Format;
        private final Function<Integer, String> level2Compress;
        private final Map<String, Optional<SimpleStatsExtractor>> format2Extractor;
        private final Map<String, DataFilePathFactory> format2PathFactory;
        private final Map<String, FormatWriterFactory> format2WriterFactory;

        private WriteFormatContext(BinaryRow partition, int bucket, RowType rowType, FileFormat defaultFormat, Map<String, FileStorePathFactory> parentFactories, CoreOptions options) {
            Map<Integer, String> fileFormatPerLevel = options.fileFormatPerLevel();
            this.level2Format = level -> fileFormatPerLevel.getOrDefault(level, defaultFormat.getFormatIdentifier());
            String defaultCompress = options.fileCompression();
            Map<Integer, String> fileCompressionPerLevel = options.fileCompressionPerLevel();
            this.level2Compress = level -> fileCompressionPerLevel.getOrDefault(level, defaultCompress);
            this.format2Extractor = new HashMap<String, Optional<SimpleStatsExtractor>>();
            this.format2PathFactory = new HashMap<String, DataFilePathFactory>();
            this.format2WriterFactory = new HashMap<String, FormatWriterFactory>();
            SimpleColStatsCollector.Factory[] statsCollectorFactories = StatsCollectorFactories.createStatsFactories(options, rowType.getFieldNames());
            for (String format : parentFactories.keySet()) {
                this.format2PathFactory.put(format, parentFactories.get(format).createDataFilePathFactory(partition, bucket));
                FileFormat fileFormat = FileFormat.getFileFormat(options.toConfiguration(), format);
                this.format2Extractor.put(format, format.equals("avro") ? Optional.empty() : fileFormat.createStatsExtractor(rowType, statsCollectorFactories));
                this.format2WriterFactory.put(format, fileFormat.createWriterFactory(rowType));
            }
        }

        @Nullable
        private SimpleStatsExtractor extractor(int level) {
            return this.format2Extractor.get(this.level2Format.apply(level)).orElse(null);
        }

        private DataFilePathFactory pathFactory(int level) {
            return this.format2PathFactory.get(this.level2Format.apply(level));
        }

        private FormatWriterFactory writerFactory(int level) {
            return this.format2WriterFactory.get(this.level2Format.apply(level));
        }

        private String compression(int level) {
            return this.level2Compress.apply(level);
        }
    }

    public static class Builder {
        private final FileIO fileIO;
        private final long schemaId;
        private final RowType keyType;
        private final RowType valueType;
        private final FileFormat fileFormat;
        private final Map<String, FileStorePathFactory> format2PathFactory;
        private final long suggestedFileSize;

        private Builder(FileIO fileIO, long schemaId, RowType keyType, RowType valueType, FileFormat fileFormat, Map<String, FileStorePathFactory> format2PathFactory, long suggestedFileSize) {
            this.fileIO = fileIO;
            this.schemaId = schemaId;
            this.keyType = keyType;
            this.valueType = valueType;
            this.fileFormat = fileFormat;
            this.format2PathFactory = format2PathFactory;
            this.suggestedFileSize = suggestedFileSize;
        }

        public KeyValueFileWriterFactory build(BinaryRow partition, int bucket, CoreOptions options) {
            RowType fileRowType = KeyValue.schema(this.keyType, this.valueType);
            WriteFormatContext context = new WriteFormatContext(partition, bucket, fileRowType, this.fileFormat, this.format2PathFactory, options);
            return new KeyValueFileWriterFactory(this.fileIO, this.schemaId, this.keyType, this.valueType, context, this.suggestedFileSize, options);
        }
    }
}

