/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.pool;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.client.ClientPool;
import org.apache.paimon.hive.HiveCatalogOptions;
import org.apache.paimon.hive.pool.HiveClientPool;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Cache;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Scheduler;
import org.apache.paimon.shade.guava30.com.google.common.collect.Lists;
import org.apache.paimon.shade.guava30.com.google.common.collect.Maps;
import org.apache.paimon.shade.guava30.com.google.common.collect.Sets;
import org.apache.paimon.shade.guava30.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.paimon.utils.Preconditions;
import org.apache.thrift.TException;

public class CachedClientPool
implements ClientPool<IMetaStoreClient, TException> {
    private static final String CONF_ELEMENT_PREFIX = "conf:";
    private static Cache<Key, HiveClientPool> clientPoolCache;
    private final Configuration conf;
    private final int clientPoolSize;
    private final long evictionInterval;
    private final Key key;
    private final String clientClassName;

    public CachedClientPool(Configuration conf, Options options, String clientClassName) {
        this.conf = conf;
        this.clientPoolSize = options.get(CatalogOptions.CLIENT_POOL_SIZE);
        this.evictionInterval = options.get(HiveCatalogOptions.CLIENT_POOL_CACHE_EVICTION_INTERVAL_MS);
        this.key = CachedClientPool.extractKey(clientClassName, options.get(HiveCatalogOptions.CLIENT_POOL_CACHE_KEYS), conf);
        this.clientClassName = clientClassName;
        this.init();
        try {
            this.run(client -> null);
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    HiveClientPool clientPool() {
        return clientPoolCache.get(this.key, k -> new HiveClientPool(this.clientPoolSize, this.conf, this.clientClassName));
    }

    private synchronized void init() {
        if (clientPoolCache == null) {
            clientPoolCache = Caffeine.newBuilder().expireAfterAccess(this.evictionInterval, TimeUnit.MILLISECONDS).removalListener((ignored, value, cause) -> {
                if (value != null) {
                    ((HiveClientPool)value).close();
                }
            }).scheduler(Scheduler.forScheduledExecutorService(Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("hive-metastore-cleaner").build()))).build();
        }
    }

    @VisibleForTesting
    static Cache<Key, HiveClientPool> clientPoolCache() {
        return clientPoolCache;
    }

    @Override
    public <R> R run(ClientPool.Action<R, IMetaStoreClient, TException> action) throws TException, InterruptedException {
        return this.clientPool().run(action);
    }

    @Override
    public <R> R run(ClientPool.Action<R, IMetaStoreClient, TException> action, boolean retry) throws TException, InterruptedException {
        return this.clientPool().run(action, retry);
    }

    @Override
    public void execute(ClientPool.ExecuteAction<IMetaStoreClient, TException> action) throws TException, InterruptedException {
        this.clientPool().execute(action);
    }

    @Override
    public void execute(ClientPool.ExecuteAction<IMetaStoreClient, TException> action, boolean retry) throws TException, InterruptedException {
        this.clientPool().execute(action, retry);
    }

    @VisibleForTesting
    static Key extractKey(String clientClassName, String cacheKeys, Configuration conf) {
        ArrayList<Object> elements = Lists.newArrayList();
        elements.add(clientClassName);
        elements.add(conf.get(HiveConf.ConfVars.METASTOREURIS.varname, ""));
        elements.add("hive");
        if (cacheKeys == null || cacheKeys.isEmpty()) {
            return Key.of(elements);
        }
        TreeSet<KeyElementType> types = Sets.newTreeSet(Comparator.comparingInt(Enum::ordinal));
        TreeMap<String, String> confElements = Maps.newTreeMap();
        block11: for (String element : cacheKeys.split(",", -1)) {
            String trimmed = element.trim();
            if (trimmed.toLowerCase(Locale.ROOT).startsWith(CONF_ELEMENT_PREFIX)) {
                String key = trimmed.substring(CONF_ELEMENT_PREFIX.length());
                Preconditions.checkArgument(!confElements.containsKey(key), "Conf key element %s already specified", key);
                confElements.put(key, conf.get(key));
                continue;
            }
            KeyElementType type = KeyElementType.valueOf(trimmed.toUpperCase());
            switch (type) {
                case UGI: 
                case USER_NAME: {
                    Preconditions.checkArgument(!types.contains((Object)type), "%s key element already specified", type.name());
                    types.add(type);
                    continue block11;
                }
                default: {
                    throw new RuntimeException("Unknown key element %s" + trimmed);
                }
            }
        }
        block12: for (KeyElementType type : types) {
            switch (type) {
                case UGI: {
                    try {
                        elements.add(UserGroupInformation.getCurrentUser());
                        continue block12;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                case USER_NAME: {
                    try {
                        elements.add(UserGroupInformation.getCurrentUser().getUserName());
                        continue block12;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
            throw new RuntimeException("Unexpected key element " + type.name());
        }
        for (String key : confElements.keySet()) {
            elements.add(ConfElement.of(key, (String)confElements.get(key)));
        }
        return Key.of(elements);
    }

    private static enum KeyElementType {
        UGI,
        USER_NAME,
        CONF;

    }

    static class ConfElement {
        private final String key;
        private final String value;

        private ConfElement(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String key() {
            return this.key;
        }

        @Nullable
        public String value() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ConfElement other = (ConfElement)obj;
            return Objects.equals(this.key, other.key) && Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public static ConfElement of(String key, String value) {
            return new ConfElement(key, value);
        }
    }

    static class Key {
        private final List<Object> elements;

        private Key(List<Object> elements) {
            this.elements = Collections.unmodifiableList(new ArrayList<Object>(elements));
        }

        public List<Object> elements() {
            return this.elements;
        }

        public static Key of(List<Object> elements) {
            return new Key(elements);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key that = (Key)o;
            if (this.elements.size() != that.elements.size()) {
                return false;
            }
            for (int i = 0; i < this.elements.size(); ++i) {
                if (Objects.equals(this.elements.get(i), that.elements.get(i))) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            int hashCode = 0;
            List<Object> list = this.elements;
            synchronized (list) {
                for (Object p : this.elements) {
                    hashCode ^= p.hashCode();
                }
            }
            return hashCode;
        }
    }
}

