/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.client.ClientPool;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.hive.SerializableHiveConf;
import org.apache.paimon.hive.pool.CachedClientPool;
import org.apache.paimon.metastore.MetastoreClient;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.utils.InternalRowPartitionComputer;
import org.apache.paimon.utils.PartitionPathUtils;
import org.apache.thrift.TException;

public class HiveMetastoreClient
implements MetastoreClient {
    private final Identifier identifier;
    private final InternalRowPartitionComputer partitionComputer;
    private final ClientPool<IMetaStoreClient, TException> clients;
    private final StorageDescriptor sd;

    HiveMetastoreClient(Identifier identifier, TableSchema schema, ClientPool<IMetaStoreClient, TException> clients) throws TException, InterruptedException {
        this.identifier = identifier;
        this.partitionComputer = new InternalRowPartitionComputer(new CoreOptions(schema.options()).partitionDefaultName(), schema.logicalPartitionType(), schema.partitionKeys().toArray(new String[0]));
        this.clients = clients;
        this.sd = this.clients.run(client -> client.getTable(identifier.getDatabaseName(), identifier.getTableName())).getSd();
    }

    @Override
    public void addPartition(BinaryRow partition) throws Exception {
        this.addPartition(this.partitionComputer.generatePartValues(partition));
    }

    @Override
    public void addPartition(LinkedHashMap<String, String> partitionSpec) throws Exception {
        ArrayList<String> partitionValues = new ArrayList<String>(partitionSpec.values());
        try {
            this.clients.execute(client -> client.getPartition(this.identifier.getDatabaseName(), this.identifier.getTableName(), partitionValues));
        }
        catch (NoSuchObjectException e) {
            StorageDescriptor newSd = new StorageDescriptor(this.sd);
            newSd.setLocation(this.sd.getLocation() + "/" + PartitionPathUtils.generatePartitionPath(partitionSpec));
            Partition hivePartition = new Partition();
            hivePartition.setDbName(this.identifier.getDatabaseName());
            hivePartition.setTableName(this.identifier.getTableName());
            hivePartition.setValues(partitionValues);
            hivePartition.setSd(newSd);
            int currentTime = (int)(System.currentTimeMillis() / 1000L);
            hivePartition.setCreateTime(currentTime);
            hivePartition.setLastAccessTime(currentTime);
            this.clients.execute(client -> client.add_partition(hivePartition));
        }
    }

    @Override
    public void deletePartition(LinkedHashMap<String, String> partitionSpec) throws Exception {
        ArrayList<String> partitionValues = new ArrayList<String>(partitionSpec.values());
        try {
            this.clients.execute(client -> client.dropPartition(this.identifier.getDatabaseName(), this.identifier.getTableName(), partitionValues, false));
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Override
    public void markDone(LinkedHashMap<String, String> partitionSpec) throws Exception {
        try {
            this.clients.execute(client -> client.markPartitionForEvent(this.identifier.getDatabaseName(), this.identifier.getTableName(), (Map)partitionSpec, PartitionEventType.LOAD_DONE));
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws Exception {
    }

    public IMetaStoreClient client() throws TException, InterruptedException {
        return this.clients.run(client -> client);
    }

    public static class Factory
    implements MetastoreClient.Factory {
        private static final long serialVersionUID = 1L;
        private final Identifier identifier;
        private final TableSchema schema;
        private final SerializableHiveConf hiveConf;
        private final String clientClassName;
        private final Options options;

        public Factory(Identifier identifier, TableSchema schema, HiveConf hiveConf, String clientClassName, Options options) {
            this.identifier = identifier;
            this.schema = schema;
            this.hiveConf = new SerializableHiveConf(hiveConf);
            this.clientClassName = clientClassName;
            this.options = options;
        }

        @Override
        public MetastoreClient create() {
            HiveConf conf = this.hiveConf.conf();
            try {
                return new HiveMetastoreClient(this.identifier, this.schema, new CachedClientPool((Configuration)conf, this.options, this.clientClassName));
            }
            catch (TException e) {
                throw new RuntimeException("Can not get table " + this.identifier + " info from metastore.", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted in call to new HiveMetastoreClient for table " + this.identifier, e);
            }
        }
    }
}

