/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.avro;

import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.avro.AvroRowDatumReader;
import org.apache.paimon.format.avro.SeekableInputStreamWrapper;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.org.apache.avro.file.DataFileReader;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.IteratorResultIterator;
import org.apache.paimon.utils.Pool;

public class AvroBulkFormat
implements FormatReaderFactory {
    protected final RowType projectedRowType;

    public AvroBulkFormat(RowType projectedRowType) {
        this.projectedRowType = projectedRowType;
    }

    @Override
    public RecordReader<InternalRow> createReader(FormatReaderFactory.Context context) throws IOException {
        return new AvroReader(context.fileIO(), context.filePath(), context.fileSize());
    }

    private static class AvroBlockIterator
    implements Iterator<InternalRow> {
        private long numRecordsRemaining;
        private final DataFileReader<InternalRow> reader;

        private AvroBlockIterator(long numRecordsRemaining, DataFileReader<InternalRow> reader) {
            this.numRecordsRemaining = numRecordsRemaining;
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            return this.numRecordsRemaining > 0L;
        }

        @Override
        public InternalRow next() {
            try {
                --this.numRecordsRemaining;
                return this.reader.next(null);
            }
            catch (IOException e) {
                throw new RuntimeException("Encountered exception when reading from avro format file", e);
            }
        }
    }

    private class AvroReader
    implements RecordReader<InternalRow> {
        private final FileIO fileIO;
        private final DataFileReader<InternalRow> reader;
        private final long end;
        private final Pool<Object> pool;
        private final Path filePath;
        private long currentRowPosition;

        private AvroReader(FileIO fileIO, Path path, long fileSize) throws IOException {
            this.fileIO = fileIO;
            this.end = fileSize;
            this.reader = this.createReaderFromPath(path, this.end);
            this.reader.sync(0L);
            this.pool = new Pool(1);
            this.pool.add(new Object());
            this.filePath = path;
            this.currentRowPosition = 0L;
        }

        private DataFileReader<InternalRow> createReaderFromPath(Path path, long fileSize) throws IOException {
            AvroRowDatumReader datumReader = new AvroRowDatumReader(AvroBulkFormat.this.projectedRowType);
            SeekableInputStreamWrapper in = new SeekableInputStreamWrapper(this.fileIO.newInputStream(path), fileSize);
            try {
                return (DataFileReader)DataFileReader.openReader(in, datumReader);
            }
            catch (Throwable e) {
                IOUtils.closeQuietly(in);
                throw e;
            }
        }

        @Override
        @Nullable
        public RecordReader.RecordIterator<InternalRow> readBatch() throws IOException {
            Object ticket;
            try {
                ticket = this.pool.pollEntry();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted while waiting for the previous batch to be consumed", e);
            }
            if (!this.readNextBlock()) {
                this.pool.recycler().recycle(ticket);
                return null;
            }
            long rowPosition = this.currentRowPosition;
            this.currentRowPosition += this.reader.getBlockCount();
            AvroBlockIterator iterator = new AvroBlockIterator(this.reader.getBlockCount(), this.reader);
            return new IteratorResultIterator(iterator, () -> this.pool.recycler().recycle(ticket), this.filePath, rowPosition);
        }

        private boolean readNextBlock() throws IOException {
            return this.reader.hasNext() && !this.reader.pastSync(this.end);
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

