/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.format.FileFormatFactory;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.SimpleStatsExtractor;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.statistics.SimpleColStatsCollector;
import org.apache.paimon.types.RowType;

public abstract class FileFormat {
    protected String formatIdentifier;

    protected FileFormat(String formatIdentifier) {
        this.formatIdentifier = formatIdentifier;
    }

    public String getFormatIdentifier() {
        return this.formatIdentifier;
    }

    public abstract FormatReaderFactory createReaderFactory(RowType var1, @Nullable List<Predicate> var2);

    public abstract FormatWriterFactory createWriterFactory(RowType var1);

    public abstract void validateDataFields(RowType var1);

    public FormatReaderFactory createReaderFactory(RowType rowType) {
        return this.createReaderFactory(rowType, new ArrayList<Predicate>());
    }

    public Optional<SimpleStatsExtractor> createStatsExtractor(RowType type, SimpleColStatsCollector.Factory[] statsCollectors) {
        return Optional.empty();
    }

    @VisibleForTesting
    public static FileFormat fromIdentifier(String identifier, Options options) {
        return FileFormat.fromIdentifier(identifier, new FileFormatFactory.FormatContext(options, 1024));
    }

    public static FileFormat fromIdentifier(String identifier, FileFormatFactory.FormatContext context) {
        return FileFormat.fromIdentifier(identifier, context, FileFormat.class.getClassLoader()).orElseThrow(() -> new RuntimeException(String.format("Could not find a FileFormatFactory implementation class for %s format", identifier)));
    }

    private static Optional<FileFormat> fromIdentifier(String formatIdentifier, FileFormatFactory.FormatContext context, ClassLoader classLoader) {
        ServiceLoader<FileFormatFactory> serviceLoader = ServiceLoader.load(FileFormatFactory.class, classLoader);
        for (FileFormatFactory factory : serviceLoader) {
            if (!factory.identifier().equals(formatIdentifier.toLowerCase())) continue;
            return Optional.of(factory.create(context));
        }
        return Optional.empty();
    }

    public static FileFormat getFileFormat(Options options, String formatIdentifier) {
        FileFormatFactory.FormatContext context = new FileFormatFactory.FormatContext(options.removePrefix(formatIdentifier + "."), options.get(CoreOptions.READ_BATCH_SIZE), options.get(CoreOptions.FILE_COMPRESSION_ZSTD_LEVEL), options.get(CoreOptions.FILE_BLOCK_SIZE));
        return FileFormat.fromIdentifier(formatIdentifier, context);
    }
}

