/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTablesCompactorUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MultiTablesCompactorUtil.class);

    public static Map<String, String> compactOptions(boolean isStreaming) {
        if (isStreaming) {
            return new HashMap<String, String>(){
                {
                    this.put(CoreOptions.STREAM_SCAN_MODE.key(), CoreOptions.StreamScanMode.COMPACT_BUCKET_TABLE.getValue());
                    this.put(CoreOptions.SCAN_BOUNDED_WATERMARK.key(), null);
                    this.put(CoreOptions.WRITE_ONLY.key(), "false");
                }
            };
        }
        return new HashMap<String, String>(){
            {
                this.put(CoreOptions.SCAN_TIMESTAMP_MILLIS.key(), null);
                this.put(CoreOptions.SCAN_TIMESTAMP.key(), null);
                this.put(CoreOptions.SCAN_FILE_CREATION_TIME_MILLIS.key(), null);
                this.put(CoreOptions.SCAN_SNAPSHOT_ID.key(), null);
                this.put(CoreOptions.SCAN_MODE.key(), CoreOptions.StartupMode.LATEST_FULL.toString());
                this.put(CoreOptions.WRITE_ONLY.key(), "false");
            }
        };
    }

    public static boolean shouldCompactTable(Identifier tableIdentifier, Pattern includingPattern, Pattern excludingPattern) {
        String paimonFullTableName = tableIdentifier.getFullName();
        boolean shouldCompaction = includingPattern.matcher(paimonFullTableName).matches();
        if (excludingPattern != null) {
            boolean bl = shouldCompaction = shouldCompaction && !excludingPattern.matcher(paimonFullTableName).matches();
        }
        if (!shouldCompaction) {
            LOG.debug("Source table '{}' is excluded.", (Object)paimonFullTableName);
        }
        return shouldCompaction;
    }
}

