/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source.operator;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.source.RichSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.paimon.catalog.Catalog;

public abstract class CombinedCompactorSourceFunction<T>
extends RichSourceFunction<T> {
    private static final long serialVersionUID = 2L;
    protected final Catalog.Loader catalogLoader;
    protected final Pattern includingPattern;
    protected final Pattern excludingPattern;
    protected final Pattern databasePattern;
    protected final boolean isStreaming;
    protected transient AtomicBoolean isRunning;
    protected transient SourceFunction.SourceContext<T> ctx;

    public CombinedCompactorSourceFunction(Catalog.Loader catalogLoader, Pattern includingPattern, Pattern excludingPattern, Pattern databasePattern, boolean isStreaming) {
        this.catalogLoader = catalogLoader;
        this.includingPattern = includingPattern;
        this.excludingPattern = excludingPattern;
        this.databasePattern = databasePattern;
        this.isStreaming = isStreaming;
    }

    public void open(Configuration parameters) throws Exception {
        this.isRunning = new AtomicBoolean(true);
    }

    public void run(SourceFunction.SourceContext<T> sourceContext) throws Exception {
        this.ctx = sourceContext;
        this.scanTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (this.ctx != null) {
            Object object = this.ctx.getCheckpointLock();
            synchronized (object) {
                this.isRunning.set(false);
            }
        } else {
            this.isRunning.set(false);
        }
    }

    abstract void scanTable() throws Exception;
}

