/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.time.Duration;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.paimon.append.MultiTableUnawareAppendCompactionTask;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.flink.LogicalTypeConversion;
import org.apache.paimon.flink.source.operator.CombinedAwareBatchSourceFunction;
import org.apache.paimon.flink.source.operator.CombinedAwareStreamingSourceFunction;
import org.apache.paimon.flink.source.operator.CombinedUnawareBatchSourceFunction;
import org.apache.paimon.flink.source.operator.CombinedUnawareStreamingSourceFunction;
import org.apache.paimon.table.system.BucketsTable;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public class CombinedTableCompactorSourceBuilder {
    private final Catalog.Loader catalogLoader;
    private final Pattern includingPattern;
    private final Pattern excludingPattern;
    private final Pattern databasePattern;
    private final long monitorInterval;
    private boolean isContinuous = false;
    private StreamExecutionEnvironment env;
    @Nullable
    private Duration partitionIdleTime = null;

    public CombinedTableCompactorSourceBuilder(Catalog.Loader catalogLoader, Pattern databasePattern, Pattern includingPattern, Pattern excludingPattern, long monitorInterval) {
        this.catalogLoader = catalogLoader;
        this.includingPattern = includingPattern;
        this.excludingPattern = excludingPattern;
        this.databasePattern = databasePattern;
        this.monitorInterval = monitorInterval;
    }

    public CombinedTableCompactorSourceBuilder withContinuousMode(boolean isContinuous) {
        this.isContinuous = isContinuous;
        return this;
    }

    public CombinedTableCompactorSourceBuilder withEnv(StreamExecutionEnvironment env) {
        this.env = env;
        return this;
    }

    public CombinedTableCompactorSourceBuilder withPartitionIdleTime(@Nullable Duration partitionIdleTime) {
        this.partitionIdleTime = partitionIdleTime;
        return this;
    }

    public DataStream<RowData> buildAwareBucketTableSource() {
        Preconditions.checkArgument(this.env != null, "StreamExecutionEnvironment should not be null.");
        RowType produceType = BucketsTable.getRowType();
        if (this.isContinuous) {
            return CombinedAwareStreamingSourceFunction.buildSource(this.env, "Combine-MultiBucketTables--StreamingCompactorSource", (TypeInformation<RowData>)InternalTypeInfo.of((org.apache.flink.table.types.logical.RowType)LogicalTypeConversion.toLogicalType(produceType)), this.catalogLoader, this.includingPattern, this.excludingPattern, this.databasePattern, this.monitorInterval);
        }
        return CombinedAwareBatchSourceFunction.buildSource(this.env, "Combine-MultiBucketTables-BatchCompactorSource", (TypeInformation<RowData>)InternalTypeInfo.of((org.apache.flink.table.types.logical.RowType)LogicalTypeConversion.toLogicalType(produceType)), this.catalogLoader, this.includingPattern, this.excludingPattern, this.databasePattern, this.partitionIdleTime);
    }

    public DataStream<MultiTableUnawareAppendCompactionTask> buildForUnawareBucketsTableSource() {
        Preconditions.checkArgument(this.env != null, "StreamExecutionEnvironment should not be null.");
        if (this.isContinuous) {
            return CombinedUnawareStreamingSourceFunction.buildSource(this.env, "Combined-UnawareBucketTables-StreamingCompactorSource", this.catalogLoader, this.includingPattern, this.excludingPattern, this.databasePattern, this.monitorInterval);
        }
        return CombinedUnawareBatchSourceFunction.buildSource(this.env, "Combined-UnawareBucketTables-BatchCompactorSource", this.catalogLoader, this.includingPattern, this.excludingPattern, this.databasePattern, this.partitionIdleTime);
    }
}

