/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sorter;

import java.util.List;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.data.RowData;
import org.apache.paimon.flink.sorter.HilbertSorter;
import org.apache.paimon.flink.sorter.OrderSorter;
import org.apache.paimon.flink.sorter.TableSortInfo;
import org.apache.paimon.flink.sorter.ZorderSorter;
import org.apache.paimon.table.FileStoreTable;

public abstract class TableSorter {
    protected final StreamExecutionEnvironment batchTEnv;
    protected final DataStream<RowData> origin;
    protected final FileStoreTable table;
    protected final List<String> orderColNames;

    public TableSorter(StreamExecutionEnvironment batchTEnv, DataStream<RowData> origin, FileStoreTable table, List<String> orderColNames) {
        this.batchTEnv = batchTEnv;
        this.origin = origin;
        this.table = table;
        this.orderColNames = orderColNames;
        this.checkColNames();
    }

    private void checkColNames() {
        if (this.orderColNames.size() < 1) {
            throw new IllegalArgumentException("order column names should not be empty.");
        }
        List<String> columnNames = this.table.rowType().getFieldNames();
        for (String zColumn : this.orderColNames) {
            if (columnNames.contains(zColumn)) continue;
            throw new RuntimeException("Can't find column " + zColumn + " in table columns. Possible columns are [" + (String)columnNames.stream().reduce((a, b) -> a + "," + b).get() + "]");
        }
    }

    public abstract DataStream<RowData> sort();

    public static TableSorter getSorter(StreamExecutionEnvironment batchTEnv, DataStream<RowData> origin, FileStoreTable fileStoreTable, TableSortInfo sortInfo) {
        OrderType sortStrategy = sortInfo.getSortStrategy();
        switch (sortStrategy) {
            case ORDER: {
                return new OrderSorter(batchTEnv, origin, fileStoreTable, sortInfo);
            }
            case ZORDER: {
                return new ZorderSorter(batchTEnv, origin, fileStoreTable, sortInfo);
            }
            case HILBERT: {
                return new HilbertSorter(batchTEnv, origin, fileStoreTable, sortInfo);
            }
        }
        throw new IllegalArgumentException("cannot match order type: " + (Object)((Object)sortStrategy));
    }

    public static enum OrderType {
        ORDER("order"),
        ZORDER("zorder"),
        HILBERT("hilbert");

        private final String orderType;

        private OrderType(String orderType) {
            this.orderType = orderType;
        }

        public String toString() {
            return "order type: " + this.orderType;
        }

        public static OrderType of(String orderType) {
            if (OrderType.ORDER.orderType.equalsIgnoreCase(orderType)) {
                return ORDER;
            }
            if (OrderType.ZORDER.orderType.equalsIgnoreCase(orderType)) {
                return ZORDER;
            }
            if (OrderType.HILBERT.orderType.equalsIgnoreCase(orderType)) {
                return HILBERT;
            }
            throw new IllegalArgumentException("cannot match type: " + orderType + " for ordering");
        }
    }
}

