/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.flink.sink.cdc.EventParser;
import org.apache.paimon.flink.sink.cdc.RichCdcRecord;
import org.apache.paimon.types.DataField;

public class RichEventParser
implements EventParser<RichCdcRecord> {
    private RichCdcRecord record;
    private final LinkedHashMap<String, DataField> previousDataFields = new LinkedHashMap();

    @Override
    public void setRawEvent(RichCdcRecord rawEvent) {
        this.record = rawEvent;
    }

    @Override
    public List<DataField> parseSchemaChange() {
        ArrayList<DataField> change = new ArrayList<DataField>();
        this.record.fields().forEach(dataField -> {
            DataField previous = this.previousDataFields.get(dataField.name());
            if (!this.dataFieldEqualsIgnoreId(previous, (DataField)dataField)) {
                this.previousDataFields.put(dataField.name(), (DataField)dataField);
                change.add((DataField)dataField);
            }
        });
        return change;
    }

    private boolean dataFieldEqualsIgnoreId(DataField dataField1, DataField dataField2) {
        if (dataField1 == dataField2) {
            return true;
        }
        if (dataField1 != null && dataField2 != null) {
            return Objects.equals(dataField1.name(), dataField2.name()) && Objects.equals(dataField1.type(), dataField2.type()) && Objects.equals(dataField1.description(), dataField2.description());
        }
        return false;
    }

    @Override
    public List<CdcRecord> parseRecords() {
        if (this.record.hasPayload()) {
            return Collections.singletonList(this.record.toCdcRecord());
        }
        return Collections.emptyList();
    }
}

