/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.action.cdc.TableNameConverter;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.flink.sink.cdc.EventParser;
import org.apache.paimon.flink.sink.cdc.NewTableSchemaBuilder;
import org.apache.paimon.flink.sink.cdc.RichCdcMultiplexRecord;
import org.apache.paimon.flink.sink.cdc.RichEventParser;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.types.DataField;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RichCdcMultiplexRecordEventParser
implements EventParser<RichCdcMultiplexRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(RichCdcMultiplexRecordEventParser.class);
    @Nullable
    private final NewTableSchemaBuilder schemaBuilder;
    @Nullable
    private final Pattern includingPattern;
    @Nullable
    private final Pattern excludingPattern;
    private final TableNameConverter tableNameConverter;
    private final Set<String> createdTables;
    private final Map<String, RichEventParser> parsers = new HashMap<String, RichEventParser>();
    private final Set<String> includedTables = new HashSet<String>();
    private final Set<String> excludedTables = new HashSet<String>();
    private RichCdcMultiplexRecord record;
    private String currentTable;
    private boolean shouldSynchronizeCurrentTable;
    private RichEventParser currentParser;

    public RichCdcMultiplexRecordEventParser(boolean caseSensitive) {
        this(null, null, null, new TableNameConverter(caseSensitive), new HashSet<String>());
    }

    public RichCdcMultiplexRecordEventParser(@Nullable NewTableSchemaBuilder schemaBuilder, @Nullable Pattern includingPattern, @Nullable Pattern excludingPattern, TableNameConverter tableNameConverter, Set<String> createdTables) {
        this.schemaBuilder = schemaBuilder;
        this.includingPattern = includingPattern;
        this.excludingPattern = excludingPattern;
        this.tableNameConverter = tableNameConverter;
        this.createdTables = createdTables;
    }

    @Override
    public void setRawEvent(RichCdcMultiplexRecord record) {
        this.record = record;
        this.currentTable = record.tableName();
        this.shouldSynchronizeCurrentTable = this.shouldSynchronizeCurrentTable();
        if (this.shouldSynchronizeCurrentTable) {
            this.currentParser = this.parsers.computeIfAbsent(this.currentTable, t -> new RichEventParser());
            this.currentParser.setRawEvent(record.toRichCdcRecord());
        }
    }

    @Override
    public String parseTableName() {
        if (this.record.databaseName() == null || this.record.tableName() == null) {
            throw new IllegalArgumentException("Cannot synchronize record when database name or table name is unknown. Invalid record is:\n" + this.record);
        }
        return this.tableNameConverter.convert(Identifier.create(this.record.databaseName(), this.currentTable));
    }

    @Override
    public List<DataField> parseSchemaChange() {
        return this.shouldSynchronizeCurrentTable ? this.currentParser.parseSchemaChange() : Collections.emptyList();
    }

    @Override
    public List<CdcRecord> parseRecords() {
        return this.shouldSynchronizeCurrentTable ? this.currentParser.parseRecords() : Collections.emptyList();
    }

    @Override
    public Optional<Schema> parseNewTable() {
        if (this.shouldCreateCurrentTable()) {
            Preconditions.checkNotNull(this.schemaBuilder, "NewTableSchemaBuilder hasn't been set.");
            return this.schemaBuilder.build(this.record);
        }
        return Optional.empty();
    }

    private boolean shouldSynchronizeCurrentTable() {
        if (this.currentTable == null) {
            return true;
        }
        if (this.includedTables.contains(this.currentTable)) {
            return true;
        }
        if (this.excludedTables.contains(this.currentTable)) {
            return false;
        }
        boolean shouldSynchronize = true;
        if (this.includingPattern != null) {
            shouldSynchronize = this.includingPattern.matcher(this.currentTable).matches();
        }
        if (this.excludingPattern != null) {
            boolean bl = shouldSynchronize = shouldSynchronize && !this.excludingPattern.matcher(this.currentTable).matches();
        }
        if (!shouldSynchronize) {
            LOG.debug("Source table {} won't be synchronized because it was excluded. ", (Object)this.currentTable);
            this.excludedTables.add(this.currentTable);
            return false;
        }
        this.includedTables.add(this.currentTable);
        return true;
    }

    private boolean shouldCreateCurrentTable() {
        return this.shouldSynchronizeCurrentTable && !this.record.fields().isEmpty() && this.createdTables.add(this.parseTableName());
    }
}

