/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.util.Collector;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.flink.sink.cdc.CdcMultiplexRecord;
import org.apache.paimon.flink.sink.cdc.CdcRecord;

public class CaseSensitiveUtils {
    public static DataStream<CdcRecord> cdcRecordConvert(Catalog.Loader catalogLoader, DataStream<CdcRecord> input) {
        if (CaseSensitiveUtils.allowUpperCase(catalogLoader)) {
            return input;
        }
        return input.forward().process((ProcessFunction)new ProcessFunction<CdcRecord, CdcRecord>(){

            public void processElement(CdcRecord record, ProcessFunction.Context ctx, Collector<CdcRecord> out) {
                out.collect((Object)record.fieldNameLowerCase());
            }
        }).name("Case-insensitive Convert");
    }

    public static DataStream<CdcMultiplexRecord> cdcMultiplexRecordConvert(Catalog.Loader catalogLoader, DataStream<CdcMultiplexRecord> input) {
        if (CaseSensitiveUtils.allowUpperCase(catalogLoader)) {
            return input;
        }
        return input.forward().process((ProcessFunction)new ProcessFunction<CdcMultiplexRecord, CdcMultiplexRecord>(){

            public void processElement(CdcMultiplexRecord record, ProcessFunction.Context ctx, Collector<CdcMultiplexRecord> out) {
                out.collect((Object)record.fieldNameLowerCase());
            }
        }).name("Case-insensitive Convert");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean allowUpperCase(Catalog.Loader catalogLoader) {
        try (Catalog catalog = catalogLoader.load();){
            boolean bl = catalog.allowUpperCase();
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

