/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.paimon.shade.guava30.com.google.common.collect.Lists;
import org.apache.paimon.utils.Preconditions;

public class StateUtils {
    @Nullable
    public static <T> T getSingleValueFromState(StateInitializationContext context, String stateName, Class<T> valueClass, T defaultValue) throws Exception {
        ListState state = context.getOperatorStateStore().getUnionListState(new ListStateDescriptor(stateName, valueClass));
        ArrayList<T> values = new ArrayList<T>();
        ((Iterable)state.get()).forEach(values::add);
        if (context.isRestored()) {
            for (int i = 1; i < values.size(); ++i) {
                Preconditions.checkState(values.get(i).equals(values.get(i - 1)), "Values in list state are not the same. This is unexpected.");
            }
        } else {
            Preconditions.checkState(values.isEmpty(), "Expecting 0 value for a fresh state but found " + values.size() + ". This is unexpected.");
        }
        if (values.isEmpty()) {
            values.add(defaultValue);
        }
        Object value = values.get(0);
        state.update(Lists.newArrayList(value));
        return (T)value;
    }
}

