/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.sink.Committable;

public class MultiTableCommittable {
    private final String database;
    private final String table;
    private final long checkpointId;
    private final Committable.Kind kind;
    private final Object wrappedCommittable;

    public MultiTableCommittable(String database, String table, long checkpointId, Committable.Kind kind, Object wrappedCommittable) {
        this.checkpointId = checkpointId;
        this.kind = kind;
        this.wrappedCommittable = wrappedCommittable;
        this.database = database;
        this.table = table;
    }

    public static MultiTableCommittable fromCommittable(Identifier id, Committable committable) {
        return new MultiTableCommittable(id.getDatabaseName(), id.getObjectName(), committable.checkpointId(), committable.kind(), committable.wrappedCommittable());
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public long checkpointId() {
        return this.checkpointId;
    }

    public Committable.Kind kind() {
        return this.kind;
    }

    public Object wrappedCommittable() {
        return this.wrappedCommittable;
    }

    public String toString() {
        return "MultiTableCommittable{checkpointId=" + this.checkpointId + ", kind=" + (Object)((Object)this.kind) + ", wrappedCommittable=" + this.wrappedCommittable + '}';
    }

    public static enum Kind {
        FILE(0),
        LOG_OFFSET(1);

        private final byte value;

        private Kind(byte value) {
            this.value = value;
        }

        public byte toByteValue() {
            return this.value;
        }

        public static Kind fromByteValue(byte value) {
            switch (value) {
                case 0: {
                    return FILE;
                }
                case 1: {
                    return LOG_OFFSET;
                }
            }
            throw new UnsupportedOperationException("Unsupported byte value '" + value + "' for value kind.");
        }
    }
}

