/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.paimon.append.UnawareAppendCompactionTask;
import org.apache.paimon.table.sink.CompactionTaskSerializer;

public class CompactionTaskSimpleSerializer
implements SimpleVersionedSerializer<UnawareAppendCompactionTask> {
    private final CompactionTaskSerializer compactionTaskSerializer;

    public CompactionTaskSimpleSerializer(CompactionTaskSerializer compactionTaskSerializer) {
        this.compactionTaskSerializer = compactionTaskSerializer;
    }

    public int getVersion() {
        return 2;
    }

    public byte[] serialize(UnawareAppendCompactionTask compactionTask) throws IOException {
        byte[] wrapped = this.compactionTaskSerializer.serialize(compactionTask);
        int version = this.compactionTaskSerializer.getVersion();
        return ByteBuffer.allocate(wrapped.length + 4).put(wrapped).putInt(version).array();
    }

    public UnawareAppendCompactionTask deserialize(int compactionTaskVersion, byte[] bytes) throws IOException {
        if (compactionTaskVersion != this.getVersion()) {
            throw new RuntimeException("Can not deserialize version: " + compactionTaskVersion);
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        byte[] wrapped = new byte[bytes.length - 4];
        buffer.get(wrapped);
        int version = buffer.getInt();
        return this.compactionTaskSerializer.deserialize(version, wrapped);
    }
}

