/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.time.Duration;
import java.util.TimeZone;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.options.ExpireConfig;
import org.apache.paimon.table.ExpireSnapshots;
import org.apache.paimon.utils.DateTimeUtils;

public class ExpireSnapshotsProcedure
extends ProcedureBase {
    @Override
    public String identifier() {
        return "expire_snapshots";
    }

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING"), isOptional=false), @ArgumentHint(name="retain_max", type=@DataTypeHint(value="INTEGER"), isOptional=true), @ArgumentHint(name="retain_min", type=@DataTypeHint(value="INTEGER"), isOptional=true), @ArgumentHint(name="older_than", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="max_deletes", type=@DataTypeHint(value="INTEGER"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String tableId, Integer retainMax, Integer retainMin, String olderThanStr, Integer maxDeletes) throws Catalog.TableNotExistException {
        ExpireSnapshots expireSnapshots = this.table(tableId).newExpireSnapshots();
        ExpireConfig.Builder builder = ExpireConfig.builder();
        if (retainMax != null) {
            builder.snapshotRetainMax(retainMax);
        }
        if (retainMin != null) {
            builder.snapshotRetainMin(retainMin);
        }
        if (olderThanStr != null) {
            builder.snapshotTimeRetain(Duration.ofMillis(System.currentTimeMillis() - DateTimeUtils.parseTimestampData(olderThanStr, 3, TimeZone.getDefault()).getMillisecond()));
        }
        if (maxDeletes != null) {
            builder.snapshotMaxDeletes(maxDeletes);
        }
        return new String[]{expireSnapshots.config(builder.build()).expire() + ""};
    }
}

