/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.log;

import java.util.Map;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.factories.FactoryUtil;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.log.LogStoreTableFactory;
import org.apache.paimon.options.Options;

public interface LogStoreRegister {
    public Map<String, String> registerTopic();

    public void unRegisterTopic();

    public static void registerLogSystem(Catalog catalog, Identifier identifier, Map<String, String> options, ClassLoader classLoader) {
        Options tableOptions = Options.fromMap(options);
        String logStore = tableOptions.get(FlinkConnectorOptions.LOG_SYSTEM);
        if (!tableOptions.get(FlinkConnectorOptions.LOG_SYSTEM).equalsIgnoreCase("none") && !catalog.tableExists(identifier)) {
            LogStoreRegister logStoreRegister = LogStoreRegister.getLogStoreRegister(identifier, classLoader, tableOptions, logStore);
            options.putAll(logStoreRegister.registerTopic());
        }
    }

    public static void unRegisterLogSystem(Identifier identifier, Map<String, String> options, ClassLoader classLoader) {
        Options tableOptions = Options.fromMap(options);
        String logStore = tableOptions.get(FlinkConnectorOptions.LOG_SYSTEM);
        if (!tableOptions.get(FlinkConnectorOptions.LOG_SYSTEM).equalsIgnoreCase("none")) {
            LogStoreRegister logStoreRegister = LogStoreRegister.getLogStoreRegister(identifier, classLoader, tableOptions, logStore);
            logStoreRegister.unRegisterTopic();
        }
    }

    public static LogStoreRegister getLogStoreRegister(final Identifier identifier, ClassLoader classLoader, final Options tableOptions, String logStore) {
        LogStoreTableFactory registerFactory = FactoryUtil.discoverFactory(classLoader, LogStoreTableFactory.class, logStore);
        return registerFactory.createRegister(new LogStoreTableFactory.RegisterContext(){

            @Override
            public Options getOptions() {
                return tableOptions;
            }

            @Override
            public Identifier getIdentifier() {
                return identifier;
            }
        });
    }
}

