/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.format;

import java.util.List;
import java.util.function.Function;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.connectors.kafka.KafkaDeserializationSchema;
import org.apache.paimon.flink.action.cdc.CdcSourceRecord;
import org.apache.paimon.flink.action.cdc.ComputedColumn;
import org.apache.paimon.flink.action.cdc.TypeMapping;
import org.apache.paimon.flink.action.cdc.format.AbstractRecordParser;
import org.apache.paimon.flink.action.cdc.format.DataFormat;
import org.apache.paimon.flink.action.cdc.format.RecordParserFactory;

public abstract class AbstractDataFormat
implements DataFormat {
    protected abstract RecordParserFactory parser();

    protected abstract Function<Configuration, KafkaDeserializationSchema<CdcSourceRecord>> kafkaDeserializer();

    protected abstract Function<Configuration, DeserializationSchema<CdcSourceRecord>> pulsarDeserializer();

    @Override
    public AbstractRecordParser createParser(TypeMapping typeMapping, List<ComputedColumn> computedColumns) {
        return this.parser().createParser(typeMapping, computedColumns);
    }

    @Override
    public KafkaDeserializationSchema<CdcSourceRecord> createKafkaDeserializer(Configuration cdcSourceConfig) {
        return this.kafkaDeserializer().apply(cdcSourceConfig);
    }

    @Override
    public DeserializationSchema<CdcSourceRecord> createPulsarDeserializer(Configuration cdcSourceConfig) {
        return this.pulsarDeserializer().apply(cdcSourceConfig);
    }
}

