/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.DeleteBranchAction;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;

public class DeleteBranchActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "delete_branch";
    private static final String BRANCH_NAME = "branch_name";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        this.checkRequiredArgument(params, BRANCH_NAME);
        Tuple3<String, String, String> tablePath = this.getTablePath(params);
        Map<String, String> catalogConfig = this.optionalConfigMap(params, "catalog_conf");
        String branchName = params.get(BRANCH_NAME);
        DeleteBranchAction action = new DeleteBranchAction((String)tablePath.f0, (String)tablePath.f1, (String)tablePath.f2, catalogConfig, branchName);
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"delete_branch\" delete a branch by name.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  delete_branch --warehouse <warehouse_path> --database <database_name> --table <table_name> --branch_name <branch_name>");
        System.out.println();
    }
}

