/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Optional;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.CloneAction;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;

public class CloneActionFactory
implements ActionFactory {
    private static final String IDENTIFIER = "clone";
    private static final String PARALLELISM = "parallelism";
    private static final String TARGET_WAREHOUSE = "target_warehouse";
    private static final String TARGET_DATABASE = "target_database";
    private static final String TARGET_TABLE = "target_table";
    private static final String TARGET_CATALOG_CONF = "target_catalog_conf";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        CloneAction cloneAction = new CloneAction(params.get("warehouse"), params.get("database"), params.get("table"), this.optionalConfigMap(params, "catalog_conf"), params.get(TARGET_WAREHOUSE), params.get(TARGET_DATABASE), params.get(TARGET_TABLE), this.optionalConfigMap(params, TARGET_CATALOG_CONF), params.get(PARALLELISM));
        return Optional.of(cloneAction);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"clone\" runs a batch job for clone the latest Snapshot.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  clone --warehouse <warehouse_path> [--database <database_name>] [--table <table_name>] [--catalog_conf <source-paimon-catalog-conf> [--catalog_conf <source-paimon-catalog-conf> ...]] --target_warehouse <target_warehouse_path> [--target_database <target_database_name>] [--target_table <target_table_name>] [--target_catalog_conf <target-paimon-catalog-conf> [--target_catalog_conf <target-paimon-catalog-conf> ...]] [--parallelism <parallelism>]");
        System.out.println();
        System.out.println("Examples:");
        System.out.println("  clone --warehouse s3:///path1/from/warehouse --database test_db --table test_table --catalog_conf s3.endpoint=https://****.com --catalog_conf s3.access-key=***** --catalog_conf s3.secret-key=***** --target_warehouse s3:///path2/to/warehouse --target_database test_db_copy --target_table test_table_copy --target_catalog_conf s3.endpoint=https://****.com --target_catalog_conf s3.access-key=***** --target_catalog_conf s3.secret-key=***** ");
    }
}

