/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.AbstractFlinkTableFactory;
import org.apache.paimon.flink.FlinkCatalog;
import org.apache.paimon.flink.FormatCatalogTable;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.SchemaManager;

public class FlinkTableFactory
extends AbstractFlinkTableFactory {
    public String factoryIdentifier() {
        return "paimon";
    }

    @Override
    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        CatalogTable table = context.getCatalogTable().getOrigin();
        if (table instanceof FormatCatalogTable) {
            return ((FormatCatalogTable)table).createTableSource(context);
        }
        this.createTableIfNeeded(context);
        return super.createDynamicTableSource(context);
    }

    @Override
    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        CatalogTable table = context.getCatalogTable().getOrigin();
        if (table instanceof FormatCatalogTable) {
            return ((FormatCatalogTable)table).createTableSink(context);
        }
        this.createTableIfNeeded(context);
        return super.createDynamicTableSink(context);
    }

    private void createTableIfNeeded(DynamicTableFactory.Context context) {
        ResolvedCatalogTable table = context.getCatalogTable();
        Options options = Options.fromMap(table.getOptions());
        if (options.get(CoreOptions.AUTO_CREATE).booleanValue()) {
            try {
                Path tablePath = CoreOptions.path(table.getOptions());
                String branch = CoreOptions.branch(table.getOptions());
                SchemaManager schemaManager = new SchemaManager(FileIO.get(tablePath, FlinkTableFactory.createCatalogContext(context)), tablePath, branch);
                if (!schemaManager.latest().isPresent()) {
                    schemaManager.createTable(FlinkCatalog.fromCatalogTable((CatalogTable)table));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

