/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.Path;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.fs.SeekableInputStream;

public class FlinkFileIO
implements FileIO {
    private static final long serialVersionUID = 1L;
    private final Path path;

    public FlinkFileIO(org.apache.paimon.fs.Path path) {
        this.path = this.path(path);
    }

    @Override
    public boolean isObjectStore() {
        try {
            return this.path.getFileSystem().getKind() != FileSystemKind.FILE_SYSTEM;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void configure(CatalogContext context) {
    }

    @Override
    public SeekableInputStream newInputStream(org.apache.paimon.fs.Path path) throws IOException {
        Path flinkPath = this.path(path);
        return new FlinkSeekableInputStream(this.getFileSystem(flinkPath).open(flinkPath));
    }

    @Override
    public PositionOutputStream newOutputStream(org.apache.paimon.fs.Path path, boolean overwrite) throws IOException {
        Path flinkPath = this.path(path);
        return new FlinkPositionOutputStream(this.getFileSystem(flinkPath).create(flinkPath, overwrite ? FileSystem.WriteMode.OVERWRITE : FileSystem.WriteMode.NO_OVERWRITE));
    }

    @Override
    public FileStatus getFileStatus(org.apache.paimon.fs.Path path) throws IOException {
        Path flinkPath = this.path(path);
        return new FlinkFileStatus(this.getFileSystem(flinkPath).getFileStatus(flinkPath));
    }

    @Override
    public FileStatus[] listStatus(org.apache.paimon.fs.Path path) throws IOException {
        Path flinkPath = this.path(path);
        FileStatus[] statuses = new FileStatus[]{};
        org.apache.flink.core.fs.FileStatus[] flinkStatuses = this.getFileSystem(flinkPath).listStatus(flinkPath);
        if (flinkStatuses != null) {
            statuses = new FileStatus[flinkStatuses.length];
            for (int i = 0; i < flinkStatuses.length; ++i) {
                statuses[i] = new FlinkFileStatus(flinkStatuses[i]);
            }
        }
        return statuses;
    }

    @Override
    public boolean exists(org.apache.paimon.fs.Path path) throws IOException {
        Path flinkPath = this.path(path);
        return this.getFileSystem(flinkPath).exists(flinkPath);
    }

    @Override
    public boolean delete(org.apache.paimon.fs.Path path, boolean recursive) throws IOException {
        Path flinkPath = this.path(path);
        return this.getFileSystem(flinkPath).delete(flinkPath, recursive);
    }

    @Override
    public boolean mkdirs(org.apache.paimon.fs.Path path) throws IOException {
        Path flinkPath = this.path(path);
        return this.getFileSystem(flinkPath).mkdirs(flinkPath);
    }

    @Override
    public boolean rename(org.apache.paimon.fs.Path src, org.apache.paimon.fs.Path dst) throws IOException {
        Path flinkSrc = this.path(src);
        Path flinkDst = this.path(dst);
        return this.getFileSystem(flinkSrc).rename(flinkSrc, flinkDst);
    }

    private Path path(org.apache.paimon.fs.Path path) {
        return new Path(path.toUri());
    }

    protected FileSystem getFileSystem(Path path) throws IOException {
        return path.getFileSystem();
    }

    private static class FlinkFileStatus
    implements FileStatus {
        private final org.apache.flink.core.fs.FileStatus status;

        private FlinkFileStatus(org.apache.flink.core.fs.FileStatus status) {
            this.status = status;
        }

        @Override
        public long getLen() {
            return this.status.getLen();
        }

        @Override
        public boolean isDir() {
            return this.status.isDir();
        }

        @Override
        public org.apache.paimon.fs.Path getPath() {
            return new org.apache.paimon.fs.Path(this.status.getPath().toUri());
        }

        @Override
        public long getModificationTime() {
            return this.status.getModificationTime();
        }
    }

    private static class FlinkPositionOutputStream
    extends PositionOutputStream {
        private final FSDataOutputStream out;

        private FlinkPositionOutputStream(FSDataOutputStream out) {
            this.out = out;
        }

        @Override
        public long getPos() throws IOException {
            return this.out.getPos();
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    private static class FlinkSeekableInputStream
    extends SeekableInputStream {
        private final FSDataInputStream in;

        private FlinkSeekableInputStream(FSDataInputStream in) {
            this.in = in;
        }

        @Override
        public void seek(long seekPos) throws IOException {
            this.in.seek(seekPos);
        }

        @Override
        public long getPos() throws IOException {
            return this.in.getPos();
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }
}

