/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.paimon.sink.v2.bucket;

import java.util.List;
import java.util.Objects;
import org.apache.flink.cdc.common.event.FlushEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEventType;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.connectors.paimon.sink.v2.bucket.BucketWrapper;

public class BucketWrapperFlushEvent
extends FlushEvent
implements BucketWrapper {
    private final int bucket;
    private final int bucketAssignTaskId;

    public BucketWrapperFlushEvent(int bucket, int sourceSubTaskId, int bucketAssignTaskId, List<TableId> tableIds, SchemaChangeEventType schemaChangeEventType) {
        super(sourceSubTaskId, tableIds, schemaChangeEventType);
        this.bucket = bucket;
        this.bucketAssignTaskId = bucketAssignTaskId;
    }

    public int getBucketAssignTaskId() {
        return this.bucketAssignTaskId;
    }

    @Override
    public int getBucket() {
        return this.bucket;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BucketWrapperFlushEvent that = (BucketWrapperFlushEvent)o;
        return this.bucket == that.bucket && this.bucketAssignTaskId == that.bucketAssignTaskId && this.getSourceSubTaskId() == that.getSourceSubTaskId();
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bucket, this.bucketAssignTaskId);
    }

    public String toString() {
        return "BucketWrapperFlushEvent{subTaskId=" + this.getSourceSubTaskId() + ", bucketAssignTaskId=" + this.bucketAssignTaskId + ", bucket=" + this.bucket + '}';
    }
}

