/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.paimon.sink.v2.bucket;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.common.event.ChangeEvent;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.common.event.SchemaChangeEventType;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.connectors.paimon.sink.v2.bucket.BucketWrapperChangeEvent;
import org.apache.flink.cdc.connectors.paimon.sink.v2.bucket.BucketWrapperFlushEvent;
import org.apache.flink.cdc.runtime.serializer.EnumSerializer;
import org.apache.flink.cdc.runtime.serializer.ListSerializer;
import org.apache.flink.cdc.runtime.serializer.TableIdSerializer;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.cdc.runtime.serializer.event.EventSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class BucketWrapperEventSerializer
extends TypeSerializerSingleton<Event> {
    private static final long serialVersionUID = 1L;
    private final EnumSerializer<EventClass> enumSerializer = new EnumSerializer(EventClass.class);
    private final EventSerializer eventSerializer = EventSerializer.INSTANCE;
    private final ListSerializer<TableId> tableIdListSerializer = new ListSerializer((TypeSerializer)TableIdSerializer.INSTANCE);
    private final EnumSerializer<SchemaChangeEventType> schemaChangeEventTypeEnumSerializer = new EnumSerializer(SchemaChangeEventType.class);
    public static final BucketWrapperEventSerializer INSTANCE = new BucketWrapperEventSerializer();

    public boolean isImmutableType() {
        return false;
    }

    public Event createInstance() {
        return new Event(){};
    }

    public Event copy(Event event) {
        return event;
    }

    public Event copy(Event from, Event reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return 0;
    }

    public void serialize(Event event, DataOutputView dataOutputView) throws IOException {
        if (event instanceof BucketWrapperChangeEvent) {
            BucketWrapperChangeEvent bucketWrapperChangeEvent = (BucketWrapperChangeEvent)event;
            this.enumSerializer.serialize((Enum)EventClass.BUCKET_WRAPPER_CHANGE_EVENT, dataOutputView);
            dataOutputView.writeInt(bucketWrapperChangeEvent.getBucket());
            this.eventSerializer.serialize((Event)bucketWrapperChangeEvent.getInnerEvent(), dataOutputView);
        } else if (event instanceof BucketWrapperFlushEvent) {
            this.enumSerializer.serialize((Enum)EventClass.BUCKET_WRAPPER_FLUSH_EVENT, dataOutputView);
            BucketWrapperFlushEvent bucketWrapperFlushEvent = (BucketWrapperFlushEvent)event;
            dataOutputView.writeInt(bucketWrapperFlushEvent.getBucket());
            dataOutputView.writeInt(bucketWrapperFlushEvent.getSourceSubTaskId());
            dataOutputView.writeInt(bucketWrapperFlushEvent.getBucketAssignTaskId());
            this.tableIdListSerializer.serialize(bucketWrapperFlushEvent.getTableIds(), dataOutputView);
            this.schemaChangeEventTypeEnumSerializer.serialize((Enum)bucketWrapperFlushEvent.getSchemaChangeEventType(), dataOutputView);
        }
    }

    public Event deserialize(DataInputView source) throws IOException {
        EventClass eventClass = (EventClass)this.enumSerializer.deserialize(source);
        if (eventClass.equals((Object)EventClass.BUCKET_WRAPPER_FLUSH_EVENT)) {
            return new BucketWrapperFlushEvent(source.readInt(), source.readInt(), source.readInt(), this.tableIdListSerializer.deserialize(source), (SchemaChangeEventType)this.schemaChangeEventTypeEnumSerializer.deserialize(source));
        }
        return new BucketWrapperChangeEvent(source.readInt(), (ChangeEvent)this.eventSerializer.deserialize(source));
    }

    public Event deserialize(Event reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public TypeSerializerSnapshot<Event> snapshotConfiguration() {
        return new EventSerializerSnapshot();
    }

    static enum EventClass {
        BUCKET_WRAPPER_CHANGE_EVENT,
        BUCKET_WRAPPER_FLUSH_EVENT;

    }

    public static final class EventSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<Event> {
        public EventSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

