/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.paimon.sink.v2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManagerImpl;
import org.apache.paimon.flink.metrics.FlinkMetricRegistry;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.StoreSinkWrite;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.memory.HeapMemorySegmentPool;
import org.apache.paimon.memory.MemoryPoolFactory;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.operation.FileStoreWrite;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.InnerTableWrite;
import org.apache.paimon.table.sink.SinkRecord;
import org.apache.paimon.table.sink.TableWriteImpl;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSinkWriteImpl
implements StoreSinkWrite {
    private static final Logger LOG = LoggerFactory.getLogger(org.apache.paimon.flink.sink.StoreSinkWriteImpl.class);
    protected final String commitUser;
    private final IOManagerImpl paimonIOManager;
    private final boolean ignorePreviousFiles;
    private final boolean waitCompaction;
    private final boolean isStreamingMode;
    @Nullable
    private final MemorySegmentPool memoryPool;
    @Nullable
    private final MemoryPoolFactory memoryPoolFactory;
    protected TableWriteImpl<?> write;
    @Nullable
    private final MetricGroup metricGroup;

    public StoreSinkWriteImpl(FileStoreTable table, String commitUser, IOManager ioManager, boolean ignorePreviousFiles, boolean waitCompaction, boolean isStreamingMode, MemoryPoolFactory memoryPoolFactory, @Nullable MetricGroup metricGroup) {
        this(table, commitUser, ioManager, ignorePreviousFiles, waitCompaction, isStreamingMode, null, memoryPoolFactory, metricGroup);
    }

    private StoreSinkWriteImpl(FileStoreTable table, String commitUser, IOManager ioManager, boolean ignorePreviousFiles, boolean waitCompaction, boolean isStreamingMode, @Nullable MemorySegmentPool memoryPool, @Nullable MemoryPoolFactory memoryPoolFactory, @Nullable MetricGroup metricGroup) {
        this.commitUser = commitUser;
        this.paimonIOManager = new IOManagerImpl(ioManager.getSpillingDirectoriesPaths());
        this.ignorePreviousFiles = ignorePreviousFiles;
        this.waitCompaction = waitCompaction;
        this.isStreamingMode = isStreamingMode;
        this.memoryPool = memoryPool;
        this.memoryPoolFactory = memoryPoolFactory;
        this.metricGroup = metricGroup;
        this.write = this.newTableWrite(table);
    }

    private TableWriteImpl<?> newTableWrite(FileStoreTable table) {
        Preconditions.checkArgument(this.memoryPool == null || this.memoryPoolFactory == null, "memoryPool and memoryPoolFactory cannot be set at the same time.");
        InnerTableWrite tableWrite = ((TableWriteImpl)table.newWrite(this.commitUser, (part, bucket) -> true).withIOManager(this.paimonIOManager)).withIgnorePreviousFiles(this.ignorePreviousFiles);
        if (this.metricGroup != null) {
            ((TableWriteImpl)tableWrite).withMetricRegistry(new FlinkMetricRegistry(this.metricGroup));
        }
        if (this.memoryPoolFactory != null) {
            return ((TableWriteImpl)tableWrite).withMemoryPoolFactory(this.memoryPoolFactory);
        }
        return ((TableWriteImpl)tableWrite).withMemoryPool(this.memoryPool != null ? this.memoryPool : new HeapMemorySegmentPool(table.coreOptions().writeBufferSize(), table.coreOptions().pageSize()));
    }

    public void withCompactExecutor(ExecutorService compactExecutor) {
        this.write.withCompactExecutor(compactExecutor);
    }

    @Override
    public void withInsertOnly(boolean b) {
    }

    @Override
    public SinkRecord write(InternalRow internalRow) throws Exception {
        return this.write.writeAndReturn(internalRow);
    }

    @Override
    public SinkRecord write(InternalRow internalRow, int i) throws Exception {
        return this.write.writeAndReturn(internalRow, i);
    }

    @Override
    public SinkRecord toLogRecord(SinkRecord record) {
        return this.write.toLogRecord(record);
    }

    @Override
    public void compact(BinaryRow partition, int bucket, boolean fullCompaction) throws Exception {
        this.write.compact(partition, bucket, fullCompaction);
    }

    @Override
    public void notifyNewFiles(long snapshotId, BinaryRow partition, int bucket, List<DataFileMeta> files) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Receive {} new files from snapshot {}, partition {}, bucket {}", new Object[]{files.size(), snapshotId, partition, bucket});
        }
        this.write.notifyNewFiles(snapshotId, partition, bucket, files);
    }

    @Override
    public List<Committable> prepareCommit(boolean waitCompaction, long checkpointId) throws IOException {
        ArrayList<Committable> committables = new ArrayList<Committable>();
        if (this.write != null) {
            try {
                for (CommitMessage committable : this.write.prepareCommit(this.waitCompaction || waitCompaction, checkpointId)) {
                    committables.add(new Committable(checkpointId, Committable.Kind.FILE, committable));
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return committables;
    }

    @Override
    public void snapshotState() {
    }

    @Override
    public boolean streamingMode() {
        return this.isStreamingMode;
    }

    @Override
    public void close() throws Exception {
        if (this.write != null) {
            this.write.close();
        }
        this.paimonIOManager.close();
    }

    @Override
    public void replace(FileStoreTable newTable) throws Exception {
        if (this.commitUser == null) {
            return;
        }
        Object states = this.write.checkpoint();
        this.write.close();
        this.write = this.newTableWrite(newTable);
        this.write.restore((List<FileStoreWrite.State<?>>)states);
    }
}

