/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.paimon.sink.v2;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.cdc.common.data.ArrayData;
import org.apache.flink.cdc.common.data.DecimalData;
import org.apache.flink.cdc.common.data.MapData;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.data.binary.BinaryArrayData;
import org.apache.flink.cdc.common.data.binary.BinaryMapData;
import org.apache.flink.cdc.common.data.binary.BinaryRecordData;
import org.apache.flink.cdc.common.event.DataChangeEvent;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypeChecks;
import org.apache.flink.cdc.common.types.DataTypeRoot;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.memory.MemorySegmentUtils;
import org.apache.paimon.types.RowKind;

public class PaimonWriterHelper {
    public static List<RecordData.FieldGetter> createFieldGetters(Schema schema, ZoneId zoneId) {
        List columns = schema.getColumns();
        ArrayList<RecordData.FieldGetter> fieldGetters = new ArrayList<RecordData.FieldGetter>(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            fieldGetters.add(PaimonWriterHelper.createFieldGetter(((Column)columns.get(i)).getType(), i, zoneId));
        }
        return fieldGetters;
    }

    private static RecordData.FieldGetter createFieldGetter(DataType fieldType, int fieldPos, ZoneId zoneId) {
        RecordData.FieldGetter & Serializable fieldGetter;
        switch (fieldType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                fieldGetter = (RecordData.FieldGetter & Serializable)row -> BinaryString.fromString(row.getString(fieldPos).toString());
                break;
            }
            case BOOLEAN: {
                fieldGetter = (RecordData.FieldGetter & Serializable)row -> row.getBoolean(fieldPos);
                break;
            }
            case BINARY: 
            case VARBINARY: {
                fieldGetter = (RecordData.FieldGetter & Serializable)row -> row.getBinary(fieldPos);
                break;
            }
            case DECIMAL: {
                int decimalPrecision = DataTypeChecks.getPrecision((DataType)fieldType);
                int decimalScale = DataTypeChecks.getScale((DataType)fieldType);
                fieldGetter = (RecordData.FieldGetter & Serializable)row -> {
                    DecimalData decimalData = row.getDecimal(fieldPos, decimalPrecision, decimalScale);
                    return Decimal.fromBigDecimal(decimalData.toBigDecimal(), decimalPrecision, decimalScale);
                };
                break;
            }
            case TINYINT: {
                fieldGetter = (RecordData.FieldGetter & Serializable)row -> row.getByte(fieldPos);
                break;
            }
            case SMALLINT: {
                fieldGetter = (RecordData.FieldGetter & Serializable)row -> row.getShort(fieldPos);
                break;
            }
            case BIGINT: {
                fieldGetter = (RecordData.FieldGetter & Serializable)row -> row.getLong(fieldPos);
                break;
            }
            case FLOAT: {
                fieldGetter = (RecordData.FieldGetter & Serializable)row -> Float.valueOf(row.getFloat(fieldPos));
                break;
            }
            case DOUBLE: {
                fieldGetter = (RecordData.FieldGetter & Serializable)row -> row.getDouble(fieldPos);
                break;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                fieldGetter = (RecordData.FieldGetter & Serializable)row -> row.getInt(fieldPos);
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                fieldGetter = (RecordData.FieldGetter & Serializable)row -> Timestamp.fromSQLTimestamp(row.getTimestamp(fieldPos, DataTypeChecks.getPrecision((DataType)fieldType)).toTimestamp());
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case TIMESTAMP_WITH_TIME_ZONE: {
                fieldGetter = (RecordData.FieldGetter & Serializable)row -> Timestamp.fromInstant(row.getLocalZonedTimestampData(fieldPos, DataTypeChecks.getPrecision((DataType)fieldType)).toInstant());
                break;
            }
            case ROW: {
                int rowFieldCount = DataTypeChecks.getFieldCount((DataType)fieldType);
                fieldGetter = new BinaryFieldDataGetter(fieldPos, DataTypeRoot.ROW, rowFieldCount);
                break;
            }
            case ARRAY: 
            case MAP: {
                fieldGetter = new BinaryFieldDataGetter(fieldPos, fieldType.getTypeRoot());
                break;
            }
            default: {
                throw new IllegalArgumentException("don't support type of " + fieldType.getTypeRoot());
            }
        }
        if (!fieldType.isNullable()) {
            return fieldGetter;
        }
        return (RecordData.FieldGetter & Serializable)row -> {
            if (row.isNullAt(fieldPos)) {
                return null;
            }
            return fieldGetter.getFieldOrNull(row);
        };
    }

    public static GenericRow convertEventToGenericRow(DataChangeEvent dataChangeEvent, List<RecordData.FieldGetter> fieldGetters) {
        GenericRow genericRow;
        RecordData recordData;
        switch (dataChangeEvent.op()) {
            case INSERT: 
            case UPDATE: 
            case REPLACE: {
                recordData = dataChangeEvent.after();
                genericRow = new GenericRow(RowKind.INSERT, recordData.getArity());
                break;
            }
            case DELETE: {
                recordData = dataChangeEvent.before();
                genericRow = new GenericRow(RowKind.DELETE, recordData.getArity());
                break;
            }
            default: {
                throw new IllegalArgumentException("don't support type of " + dataChangeEvent.op());
            }
        }
        for (int i = 0; i < recordData.getArity(); ++i) {
            genericRow.setField(i, fieldGetters.get(i).getFieldOrNull(recordData));
        }
        return genericRow;
    }

    public static class BinaryFieldDataGetter
    implements RecordData.FieldGetter {
        private final int fieldPos;
        private final DataTypeRoot dataTypeRoot;
        private final int rowFieldCount;

        BinaryFieldDataGetter(int fieldPos, DataTypeRoot dataTypeRoot) {
            this(fieldPos, dataTypeRoot, -1);
        }

        BinaryFieldDataGetter(int fieldPos, DataTypeRoot dataTypeRoot, int rowFieldCount) {
            this.fieldPos = fieldPos;
            this.dataTypeRoot = dataTypeRoot;
            this.rowFieldCount = rowFieldCount;
        }

        public Object getFieldOrNull(RecordData row) {
            switch (this.dataTypeRoot) {
                case ARRAY: {
                    return this.getArrayField(row);
                }
                case MAP: {
                    return this.getMapField(row);
                }
                case ROW: {
                    return this.getRecordField(row);
                }
            }
            throw new IllegalArgumentException("Unsupported field type: " + this.dataTypeRoot);
        }

        private Object getArrayField(RecordData row) {
            ArrayData arrayData = row.getArray(this.fieldPos);
            if (!(arrayData instanceof BinaryArrayData)) {
                throw new IllegalArgumentException("Expected BinaryArrayData but was " + arrayData.getClass().getSimpleName());
            }
            BinaryArrayData binaryArrayData = (BinaryArrayData)arrayData;
            return this.convertSegments(binaryArrayData.getSegments(), binaryArrayData.getOffset(), binaryArrayData.getSizeInBytes(), MemorySegmentUtils::readArrayData);
        }

        private Object getMapField(RecordData row) {
            MapData mapData = row.getMap(this.fieldPos);
            if (!(mapData instanceof BinaryMapData)) {
                throw new IllegalArgumentException("Expected BinaryMapData but was " + mapData.getClass().getSimpleName());
            }
            BinaryMapData binaryMapData = (BinaryMapData)mapData;
            return this.convertSegments(binaryMapData.getSegments(), binaryMapData.getOffset(), binaryMapData.getSizeInBytes(), MemorySegmentUtils::readMapData);
        }

        private Object getRecordField(RecordData row) {
            RecordData recordData = row.getRow(this.fieldPos, this.rowFieldCount);
            if (!(recordData instanceof BinaryRecordData)) {
                throw new IllegalArgumentException("Expected BinaryRecordData but was " + recordData.getClass().getSimpleName());
            }
            BinaryRecordData binaryRecordData = (BinaryRecordData)recordData;
            return this.convertSegments(binaryRecordData.getSegments(), binaryRecordData.getOffset(), binaryRecordData.getSizeInBytes(), (segments, offset, sizeInBytes) -> MemorySegmentUtils.readRowData(segments, this.rowFieldCount, offset, sizeInBytes));
        }

        private <T> T convertSegments(MemorySegment[] segments, int offset, int sizeInBytes, SegmentConverter<T> converter) {
            org.apache.paimon.memory.MemorySegment[] paimonMemorySegments = new org.apache.paimon.memory.MemorySegment[segments.length];
            for (int i = 0; i < segments.length; ++i) {
                MemorySegment currMemorySegment = segments[i];
                ByteBuffer byteBuffer = currMemorySegment.wrap(0, currMemorySegment.size());
                byte[] bytes = new byte[currMemorySegment.size()];
                byteBuffer.get(bytes);
                paimonMemorySegments[i] = org.apache.paimon.memory.MemorySegment.wrap(bytes);
            }
            return converter.convert(paimonMemorySegments, offset, sizeInBytes);
        }

        public InternalRow readRowData(org.apache.paimon.memory.MemorySegment[] segments, int numFields, int baseOffset, long offsetAndSize) {
            int size = (int)offsetAndSize;
            int offset = (int)(offsetAndSize >> 32);
            BinaryRow row = new BinaryRow(numFields);
            row.pointTo(segments, offset + baseOffset, size);
            return row;
        }

        private static interface SegmentConverter<T> {
            public T convert(org.apache.paimon.memory.MemorySegment[] var1, int var2, int var3);
        }
    }
}

