/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.paimon.sink.v2;

import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.cdc.common.event.ChangeEvent;
import org.apache.flink.cdc.common.event.CreateTableEvent;
import org.apache.flink.cdc.common.event.DataChangeEvent;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.utils.SchemaUtils;
import org.apache.flink.cdc.connectors.paimon.sink.v2.PaimonEvent;
import org.apache.flink.cdc.connectors.paimon.sink.v2.PaimonRecordSerializer;
import org.apache.flink.cdc.connectors.paimon.sink.v2.PaimonWriterHelper;
import org.apache.flink.cdc.connectors.paimon.sink.v2.TableSchemaInfo;
import org.apache.flink.cdc.connectors.paimon.sink.v2.bucket.BucketWrapperChangeEvent;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.GenericRow;

public class PaimonRecordEventSerializer
implements PaimonRecordSerializer<Event> {
    private final Map<TableId, TableSchemaInfo> schemaMaps = new HashMap<TableId, TableSchemaInfo>();
    private final ZoneId zoneId;

    public PaimonRecordEventSerializer(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    @Override
    public PaimonEvent serialize(Event event) {
        int bucket = 0;
        if (event instanceof BucketWrapperChangeEvent) {
            bucket = ((BucketWrapperChangeEvent)event).getBucket();
            event = ((BucketWrapperChangeEvent)event).getInnerEvent();
        }
        Identifier tableId = Identifier.fromString(((ChangeEvent)event).tableId().toString());
        if (event instanceof SchemaChangeEvent) {
            if (event instanceof CreateTableEvent) {
                CreateTableEvent createTableEvent = (CreateTableEvent)event;
                this.schemaMaps.put(createTableEvent.tableId(), new TableSchemaInfo(createTableEvent.getSchema(), this.zoneId));
            } else {
                SchemaChangeEvent schemaChangeEvent = (SchemaChangeEvent)event;
                Schema schema = this.schemaMaps.get(schemaChangeEvent.tableId()).getSchema();
                if (!SchemaUtils.isSchemaChangeEventRedundant((Schema)schema, (SchemaChangeEvent)schemaChangeEvent)) {
                    this.schemaMaps.put(schemaChangeEvent.tableId(), new TableSchemaInfo(SchemaUtils.applySchemaChangeEvent((Schema)schema, (SchemaChangeEvent)schemaChangeEvent), this.zoneId));
                }
            }
            return new PaimonEvent(tableId, null, true);
        }
        if (event instanceof DataChangeEvent) {
            DataChangeEvent dataChangeEvent = (DataChangeEvent)event;
            GenericRow genericRow = PaimonWriterHelper.convertEventToGenericRow(dataChangeEvent, this.schemaMaps.get(dataChangeEvent.tableId()).getFieldGetters());
            return new PaimonEvent(tableId, genericRow, false, bucket);
        }
        throw new IllegalArgumentException("failed to convert Input into PaimonEvent, unsupported event: " + event);
    }
}

