/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.paimon.sink.v2;

import java.util.Objects;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.connector.sink2.CommittableWithLineage;
import org.apache.paimon.flink.sink.MultiTableCommittable;
import org.apache.paimon.table.sink.ChannelComputer;

public class MultiTableCommittableChannelComputer
implements ChannelComputer<CommittableMessage<MultiTableCommittable>> {
    private static final long serialVersionUID = 1L;
    private transient int numChannels;

    @Override
    public void setup(int numChannels) {
        this.numChannels = numChannels;
    }

    @Override
    public int channel(CommittableMessage<MultiTableCommittable> committableMessage) {
        if (committableMessage instanceof CommittableWithLineage) {
            MultiTableCommittable multiTableCommittable = (MultiTableCommittable)((CommittableWithLineage)committableMessage).getCommittable();
            return Math.floorMod(Objects.hash(multiTableCommittable.getDatabase(), multiTableCommittable.getTable()), this.numChannels);
        }
        return Math.floorMod(Objects.hash(committableMessage), this.numChannels);
    }

    public String toString() {
        return "shuffle by table";
    }
}

