/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.paimon.sink;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.cdc.common.event.AddColumnEvent;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.utils.DataTypeUtils;
import org.apache.paimon.flink.LogicalTypeConversion;
import org.apache.paimon.schema.SchemaChange;

public class SchemaChangeProvider {
    public static List<SchemaChange> add(AddColumnEvent.ColumnWithPosition columnWithPosition) {
        ArrayList<SchemaChange> result = new ArrayList<SchemaChange>();
        result.add(SchemaChange.addColumn(columnWithPosition.getAddColumn().getName(), LogicalTypeConversion.toDataType(DataTypeUtils.toFlinkDataType((DataType)columnWithPosition.getAddColumn().getType()).getLogicalType()), columnWithPosition.getAddColumn().getComment()));
        Column column = columnWithPosition.getAddColumn();
        Optional.ofNullable(column.getDefaultValueExpression()).ifPresent(value -> {
            String key = String.format("%s.%s.%s", "fields", column.getName(), "default-value");
            result.add(SchemaChangeProvider.setOption(key, value));
        });
        return result;
    }

    public static List<SchemaChange> add(AddColumnEvent.ColumnWithPosition columnWithPosition, SchemaChange.Move move) {
        ArrayList<SchemaChange> result = new ArrayList<SchemaChange>();
        result.add(SchemaChange.addColumn(columnWithPosition.getAddColumn().getName(), LogicalTypeConversion.toDataType(DataTypeUtils.toFlinkDataType((DataType)columnWithPosition.getAddColumn().getType()).getLogicalType()), columnWithPosition.getAddColumn().getComment(), move));
        Column column = columnWithPosition.getAddColumn();
        Optional.ofNullable(column.getDefaultValueExpression()).ifPresent(value -> {
            String key = String.format("%s.%s.%s", "fields", column.getName(), "default-value");
            result.add(SchemaChangeProvider.setOption(key, value));
        });
        return result;
    }

    public static SchemaChange updateColumnType(String oldColumnName, DataType newType) {
        return SchemaChange.updateColumnType(oldColumnName, LogicalTypeConversion.toDataType(DataTypeUtils.toFlinkDataType((DataType)newType).getLogicalType()));
    }

    public static List<SchemaChange> rename(String oldColumnName, String newColumnName, Map<String, String> options) {
        ArrayList<SchemaChange> result = new ArrayList<SchemaChange>();
        result.add(SchemaChange.renameColumn(oldColumnName, newColumnName));
        String defaultValue = options.get(SchemaChangeProvider.defaultValueOptionKey(oldColumnName));
        if (defaultValue != null) {
            result.add(SchemaChange.removeOption(SchemaChangeProvider.defaultValueOptionKey(oldColumnName)));
            result.add(SchemaChange.setOption(SchemaChangeProvider.defaultValueOptionKey(newColumnName), defaultValue));
        }
        return result;
    }

    public static List<SchemaChange> drop(String columnName) {
        ArrayList<SchemaChange> result = new ArrayList<SchemaChange>();
        result.add(SchemaChange.dropColumn(columnName));
        result.add(SchemaChange.removeOption(SchemaChangeProvider.defaultValueOptionKey(columnName)));
        return result;
    }

    public static String defaultValueOptionKey(String columnName) {
        return String.format("%s.%s.%s", "fields", columnName, "default-value");
    }

    public static SchemaChange setOption(String key, String value) {
        return SchemaChange.setOption(key, value);
    }
}

