/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.paimon.sink;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.List;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.event.DataChangeEvent;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.function.HashFunction;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.connectors.paimon.sink.v2.PaimonWriterHelper;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.flink.FlinkCatalogFactory;
import org.apache.paimon.flink.sink.RowAssignerChannelComputer;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.FileStoreTable;

public class PaimonHashFunction
implements HashFunction<DataChangeEvent>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<RecordData.FieldGetter> fieldGetters;
    private final RowAssignerChannelComputer channelComputer;

    public PaimonHashFunction(Options options, TableId tableId, Schema schema, ZoneId zoneId, int parallelism) {
        FileStoreTable table;
        Catalog catalog = FlinkCatalogFactory.createPaimonCatalog(options);
        try {
            table = (FileStoreTable)catalog.getTable(Identifier.fromString(tableId.toString()));
        }
        catch (Catalog.TableNotExistException e) {
            throw new RuntimeException(e);
        }
        this.fieldGetters = PaimonWriterHelper.createFieldGetters(schema, zoneId);
        this.channelComputer = new RowAssignerChannelComputer(table.schema(), parallelism);
        this.channelComputer.setup(parallelism);
    }

    public int hashcode(DataChangeEvent event) {
        GenericRow genericRow = PaimonWriterHelper.convertEventToGenericRow(event, this.fieldGetters);
        return this.channelComputer.channel(genericRow);
    }
}

