/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.paimon.sink;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.cdc.common.configuration.ConfigOption;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.factories.DataSinkFactory;
import org.apache.flink.cdc.common.factories.Factory;
import org.apache.flink.cdc.common.factories.FactoryHelper;
import org.apache.flink.cdc.common.pipeline.PipelineOptions;
import org.apache.flink.cdc.common.sink.DataSink;
import org.apache.flink.cdc.connectors.paimon.sink.PaimonDataSink;
import org.apache.flink.cdc.connectors.paimon.sink.PaimonDataSinkOptions;
import org.apache.flink.cdc.connectors.paimon.sink.v2.PaimonRecordEventSerializer;
import org.apache.paimon.options.Options;

public class PaimonDataSinkFactory
implements DataSinkFactory {
    public static final String IDENTIFIER = "paimon";

    public DataSink createDataSink(Factory.Context context) {
        FactoryHelper.createFactoryHelper((Factory)this, (Factory.Context)context).validateExcept(new String[]{"table.properties.", "catalog.properties."});
        Map allOptions = context.getFactoryConfiguration().toMap();
        HashMap<String, String> catalogOptions = new HashMap<String, String>();
        HashMap<String, String> tableOptions = new HashMap<String, String>();
        allOptions.forEach((key, value) -> {
            if (key.startsWith("table.properties.")) {
                tableOptions.put(key.substring("table.properties.".length()), (String)value);
            } else if (key.startsWith("catalog.properties.")) {
                catalogOptions.put(key.substring("catalog.properties.".length()), (String)value);
            }
        });
        Options options = Options.fromMap(catalogOptions);
        options.setString("cache-enabled", "false");
        ZoneId zoneId = ZoneId.systemDefault();
        if (!Objects.equals(context.getPipelineConfiguration().get(PipelineOptions.PIPELINE_LOCAL_TIME_ZONE), PipelineOptions.PIPELINE_LOCAL_TIME_ZONE.defaultValue())) {
            zoneId = ZoneId.of((String)context.getPipelineConfiguration().get(PipelineOptions.PIPELINE_LOCAL_TIME_ZONE));
        }
        String commitUser = (String)context.getFactoryConfiguration().get(PaimonDataSinkOptions.COMMIT_USER);
        String partitionKey = (String)context.getFactoryConfiguration().get(PaimonDataSinkOptions.PARTITION_KEY);
        HashMap<TableId, List<String>> partitionMaps = new HashMap<TableId, List<String>>();
        if (!partitionKey.isEmpty()) {
            for (String tables : partitionKey.split(";")) {
                String[] splits = tables.split(":");
                if (splits.length != 2) {
                    throw new IllegalArgumentException(PaimonDataSinkOptions.PARTITION_KEY.key() + " is malformed, please refer to the documents");
                }
                TableId tableId = TableId.parse((String)splits[0]);
                List<String> partitions = Arrays.asList(splits[1].split(","));
                partitionMaps.put(tableId, partitions);
            }
        }
        PaimonRecordEventSerializer serializer = new PaimonRecordEventSerializer(zoneId);
        String schemaOperatorUid = (String)context.getPipelineConfiguration().get(PipelineOptions.PIPELINE_SCHEMA_OPERATOR_UID);
        return new PaimonDataSink(options, tableOptions, commitUser, partitionMaps, serializer, zoneId, schemaOperatorUid);
    }

    public String identifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(PaimonDataSinkOptions.METASTORE);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(PaimonDataSinkOptions.WAREHOUSE);
        options.add(PaimonDataSinkOptions.URI);
        options.add(PaimonDataSinkOptions.COMMIT_USER);
        options.add(PaimonDataSinkOptions.PARTITION_KEY);
        return options;
    }
}

