/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.paimon.sink;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.cdc.common.event.DataChangeEvent;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.function.HashFunctionProvider;
import org.apache.flink.cdc.common.sink.DataSink;
import org.apache.flink.cdc.common.sink.EventSinkProvider;
import org.apache.flink.cdc.common.sink.FlinkSinkProvider;
import org.apache.flink.cdc.common.sink.MetadataApplier;
import org.apache.flink.cdc.connectors.paimon.sink.PaimonHashFunctionProvider;
import org.apache.flink.cdc.connectors.paimon.sink.PaimonMetadataApplier;
import org.apache.flink.cdc.connectors.paimon.sink.v2.PaimonEventSink;
import org.apache.flink.cdc.connectors.paimon.sink.v2.PaimonRecordSerializer;
import org.apache.paimon.options.Options;

public class PaimonDataSink
implements DataSink,
Serializable {
    private final Options options;
    private final Map<String, String> tableOptions;
    private final String commitUser;
    private final Map<TableId, List<String>> partitionMaps;
    private final PaimonRecordSerializer<Event> serializer;
    private final ZoneId zoneId;
    public final String schemaOperatorUid;

    public PaimonDataSink(Options options, Map<String, String> tableOptions, String commitUser, Map<TableId, List<String>> partitionMaps, PaimonRecordSerializer<Event> serializer, ZoneId zoneId, String schemaOperatorUid) {
        this.options = options;
        this.tableOptions = tableOptions;
        this.commitUser = commitUser;
        this.partitionMaps = partitionMaps;
        this.serializer = serializer;
        this.zoneId = zoneId;
        this.schemaOperatorUid = schemaOperatorUid;
    }

    public EventSinkProvider getEventSinkProvider() {
        return FlinkSinkProvider.of((Sink)new PaimonEventSink(this.options, this.commitUser, this.serializer, this.schemaOperatorUid, this.zoneId));
    }

    public MetadataApplier getMetadataApplier() {
        return new PaimonMetadataApplier(this.options, this.tableOptions, this.partitionMaps);
    }

    public HashFunctionProvider<DataChangeEvent> getDataChangeEventHashFunctionProvider(int parallelism) {
        return new PaimonHashFunctionProvider(this.options, this.zoneId, parallelism);
    }
}

