/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.reader;

import io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.text.ParsingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.connector.source.SourceOutput;
import org.apache.flink.cdc.common.event.CreateTableEvent;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.connectors.mysql.debezium.DebeziumUtils;
import org.apache.flink.cdc.connectors.mysql.schema.MySqlFieldDefinition;
import org.apache.flink.cdc.connectors.mysql.schema.MySqlTableDefinition;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import org.apache.flink.cdc.connectors.mysql.source.metrics.MySqlSourceReaderMetrics;
import org.apache.flink.cdc.connectors.mysql.source.reader.MySqlRecordEmitter;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSplitState;
import org.apache.flink.cdc.connectors.mysql.source.utils.RecordUtils;
import org.apache.flink.cdc.connectors.mysql.source.utils.TableDiscoveryUtils;
import org.apache.flink.cdc.connectors.mysql.table.StartupMode;
import org.apache.flink.cdc.connectors.mysql.utils.MySqlSchemaUtils;
import org.apache.flink.cdc.connectors.mysql.utils.MySqlTypeUtils;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlPipelineRecordEmitter
extends MySqlRecordEmitter<Event> {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlPipelineRecordEmitter.class);
    private final MySqlSourceConfig sourceConfig;
    private MySqlAntlrDdlParser mySqlAntlrDdlParser;
    private Set<TableId> alreadySendCreateTableTables;
    private boolean alreadySendCreateTableForBinlogSplit = false;
    private List<CreateTableEvent> createTableEventCache;

    public MySqlPipelineRecordEmitter(DebeziumDeserializationSchema<Event> debeziumDeserializationSchema, MySqlSourceReaderMetrics sourceReaderMetrics, MySqlSourceConfig sourceConfig) {
        super(debeziumDeserializationSchema, sourceReaderMetrics, sourceConfig.isIncludeSchemaChanges());
        this.sourceConfig = sourceConfig;
        this.alreadySendCreateTableTables = new HashSet<TableId>();
        this.createTableEventCache = this.generateCreateTableEvent(sourceConfig);
    }

    @Override
    protected void processElement(SourceRecord element, SourceOutput<Event> output, MySqlSplitState splitState) throws Exception {
        if (RecordUtils.isLowWatermarkEvent(element) && splitState.isSnapshotSplitState()) {
            TableId tableId = splitState.asSnapshotSplitState().toMySqlSplit().getTableId();
            if (!this.alreadySendCreateTableTables.contains(tableId)) {
                try (JdbcConnection jdbc = DebeziumUtils.openJdbcConnection(this.sourceConfig);){
                    this.sendCreateTableEvent(jdbc, tableId, output);
                    this.alreadySendCreateTableTables.add(tableId);
                }
            }
        } else if (splitState.isBinlogSplitState() && !this.alreadySendCreateTableForBinlogSplit) {
            this.alreadySendCreateTableForBinlogSplit = true;
            if (this.sourceConfig.getStartupOptions().startupMode.equals((Object)StartupMode.INITIAL)) {
                this.createTableEventCache.stream().filter(event -> !this.alreadySendCreateTableTables.contains(MySqlSchemaUtils.toDbzTableId(event.tableId()))).forEach(arg_0 -> output.collect(arg_0));
            } else {
                this.createTableEventCache.forEach(arg_0 -> output.collect(arg_0));
            }
        }
        super.processElement(element, output, splitState);
    }

    private void sendCreateTableEvent(JdbcConnection jdbc, TableId tableId, SourceOutput<Event> output) {
        Schema schema = this.getSchema(jdbc, tableId);
        output.collect((Object)new CreateTableEvent(org.apache.flink.cdc.common.event.TableId.tableId((String)tableId.catalog(), (String)tableId.table()), schema));
    }

    private Schema getSchema(JdbcConnection jdbc, TableId tableId) {
        String ddlStatement = this.showCreateTable(jdbc, tableId);
        try {
            return this.parseDDL(ddlStatement, tableId);
        }
        catch (ParsingException pe) {
            LOG.warn("Failed to parse DDL: \n{}\nWill try parsing by describing table.", (Object)ddlStatement, (Object)pe);
            ddlStatement = this.describeTable(jdbc, tableId);
            return this.parseDDL(ddlStatement, tableId);
        }
    }

    private String showCreateTable(JdbcConnection jdbc, TableId tableId) {
        String showCreateTableQuery = String.format("SHOW CREATE TABLE `%s`.`%s`", tableId.catalog(), tableId.table());
        try {
            return jdbc.queryAndMap(showCreateTableQuery, rs -> {
                String ddlStatement = null;
                while (rs.next()) {
                    ddlStatement = rs.getString(2);
                }
                return ddlStatement;
            });
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to show create table for %s", tableId), e);
        }
    }

    private String describeTable(JdbcConnection jdbc, TableId tableId) {
        ArrayList fieldMetas = new ArrayList();
        ArrayList primaryKeys = new ArrayList();
        try {
            return jdbc.queryAndMap(String.format("DESC `%s`.`%s`", tableId.catalog(), tableId.table()), rs -> {
                while (rs.next()) {
                    MySqlFieldDefinition meta = new MySqlFieldDefinition();
                    meta.setColumnName(rs.getString("Field"));
                    meta.setColumnType(rs.getString("Type"));
                    meta.setNullable(StringUtils.equalsIgnoreCase((CharSequence)rs.getString("Null"), (CharSequence)"YES"));
                    meta.setKey("PRI".equalsIgnoreCase(rs.getString("Key")));
                    meta.setUnique("UNI".equalsIgnoreCase(rs.getString("Key")));
                    meta.setDefaultValue(rs.getString("Default"));
                    meta.setExtra(rs.getString("Extra"));
                    if (meta.isKey()) {
                        primaryKeys.add(meta.getColumnName());
                    }
                    fieldMetas.add(meta);
                }
                return new MySqlTableDefinition(tableId, fieldMetas, primaryKeys).toDdl();
            });
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to describe table %s", tableId), e);
        }
    }

    private Schema parseDDL(String ddlStatement, TableId tableId) {
        Table table = this.parseDdl(ddlStatement, tableId);
        List<Column> columns = table.columns();
        Schema.Builder tableBuilder = Schema.newBuilder();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            String colName = column.name();
            DataType dataType = MySqlTypeUtils.fromDbzColumn(column);
            if (!column.isOptional()) {
                dataType = dataType.notNull();
            }
            tableBuilder.physicalColumn(colName, dataType, column.comment(), (String)column.defaultValueExpression().orElse(null));
        }
        List<String> primaryKey = table.primaryKeyColumnNames();
        if (Objects.nonNull(primaryKey) && !primaryKey.isEmpty()) {
            tableBuilder.primaryKey(primaryKey);
        }
        return tableBuilder.build();
    }

    private synchronized Table parseDdl(String ddlStatement, TableId tableId) {
        MySqlAntlrDdlParser mySqlAntlrDdlParser = this.getParser();
        mySqlAntlrDdlParser.setCurrentDatabase(tableId.catalog());
        Tables tables = new Tables();
        mySqlAntlrDdlParser.parse(ddlStatement, tables);
        return tables.forTable(tableId);
    }

    private synchronized MySqlAntlrDdlParser getParser() {
        if (this.mySqlAntlrDdlParser == null) {
            this.mySqlAntlrDdlParser = new MySqlAntlrDdlParser();
        }
        return this.mySqlAntlrDdlParser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<CreateTableEvent> generateCreateTableEvent(MySqlSourceConfig sourceConfig) {
        try (JdbcConnection jdbc = DebeziumUtils.openJdbcConnection(sourceConfig);){
            ArrayList<CreateTableEvent> createTableEventCache = new ArrayList<CreateTableEvent>();
            List<TableId> capturedTableIds = TableDiscoveryUtils.listTables(jdbc, sourceConfig.getTableFilters());
            for (TableId tableId : capturedTableIds) {
                Schema schema = this.getSchema(jdbc, tableId);
                createTableEventCache.add(new CreateTableEvent(org.apache.flink.cdc.common.event.TableId.tableId((String)tableId.catalog(), (String)tableId.table()), schema));
            }
            ArrayList<CreateTableEvent> arrayList = createTableEventCache;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot start emitter to fetch table schema.", e);
        }
    }
}

