/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.assigners.state;

import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.cdc.connectors.mysql.source.assigners.AssignerStatus;
import org.apache.flink.cdc.connectors.mysql.source.assigners.state.BinlogPendingSplitsState;
import org.apache.flink.cdc.connectors.mysql.source.assigners.state.ChunkSplitterState;
import org.apache.flink.cdc.connectors.mysql.source.assigners.state.HybridPendingSplitsState;
import org.apache.flink.cdc.connectors.mysql.source.assigners.state.PendingSplitsState;
import org.apache.flink.cdc.connectors.mysql.source.assigners.state.SnapshotPendingSplitsState;
import org.apache.flink.cdc.connectors.mysql.source.offset.BinlogOffset;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSchemalessSnapshotSplit;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSnapshotSplit;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSplit;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSplitSerializer;
import org.apache.flink.cdc.connectors.mysql.source.utils.SerializerUtils;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;

public class PendingSplitsStateSerializer
implements SimpleVersionedSerializer<PendingSplitsState> {
    private static final int VERSION = 5;
    private static final ThreadLocal<DataOutputSerializer> SERIALIZER_CACHE = ThreadLocal.withInitial(() -> new DataOutputSerializer(64));
    private static final int SNAPSHOT_PENDING_SPLITS_STATE_FLAG = 1;
    private static final int BINLOG_PENDING_SPLITS_STATE_FLAG = 2;
    private static final int HYBRID_PENDING_SPLITS_STATE_FLAG = 3;
    private final SimpleVersionedSerializer<MySqlSplit> splitSerializer;

    public PendingSplitsStateSerializer(SimpleVersionedSerializer<MySqlSplit> splitSerializer) {
        this.splitSerializer = splitSerializer;
    }

    public int getVersion() {
        return 5;
    }

    public byte[] serialize(PendingSplitsState state) throws IOException {
        if (state.serializedFormCache != null) {
            return state.serializedFormCache;
        }
        DataOutputSerializer out = SERIALIZER_CACHE.get();
        out.writeInt(this.splitSerializer.getVersion());
        if (state instanceof SnapshotPendingSplitsState) {
            out.writeInt(1);
            this.serializeSnapshotPendingSplitsState((SnapshotPendingSplitsState)state, out);
        } else if (state instanceof BinlogPendingSplitsState) {
            out.writeInt(2);
            this.serializeBinlogPendingSplitsState((BinlogPendingSplitsState)state, out);
        } else if (state instanceof HybridPendingSplitsState) {
            out.writeInt(3);
            this.serializeHybridPendingSplitsState((HybridPendingSplitsState)state, out);
        } else {
            throw new IOException("Unsupported to serialize PendingSplitsState class: " + state.getClass().getName());
        }
        byte[] result = out.getCopyOfBuffer();
        state.serializedFormCache = result;
        out.clear();
        return result;
    }

    public PendingSplitsState deserialize(int version, byte[] serialized) throws IOException {
        switch (version) {
            case 1: 
            case 2: {
                return this.deserializeLegacyPendingSplitsState(serialized);
            }
            case 3: 
            case 4: 
            case 5: {
                return this.deserializePendingSplitsState(version, serialized);
            }
        }
        throw new IOException("Unknown version: " + version);
    }

    public PendingSplitsState deserializeLegacyPendingSplitsState(byte[] serialized) throws IOException {
        DataInputDeserializer in = new DataInputDeserializer(serialized);
        int splitVersion = in.readInt();
        int stateFlag = in.readInt();
        if (stateFlag == 1) {
            return this.deserializeLegacySnapshotPendingSplitsState(splitVersion, in);
        }
        if (stateFlag == 3) {
            return this.deserializeLegacyHybridPendingSplitsState(splitVersion, in);
        }
        if (stateFlag == 2) {
            return this.deserializeBinlogPendingSplitsState(in);
        }
        throw new IOException("Unsupported to deserialize PendingSplitsState flag: " + stateFlag);
    }

    public PendingSplitsState deserializePendingSplitsState(int version, byte[] serialized) throws IOException {
        DataInputDeserializer in = new DataInputDeserializer(serialized);
        int splitVersion = in.readInt();
        int stateFlag = in.readInt();
        if (stateFlag == 1) {
            return this.deserializeSnapshotPendingSplitsState(version, splitVersion, in);
        }
        if (stateFlag == 3) {
            return this.deserializeHybridPendingSplitsState(version, splitVersion, in);
        }
        if (stateFlag == 2) {
            return this.deserializeBinlogPendingSplitsState(in);
        }
        throw new IOException("Unsupported to deserialize PendingSplitsState flag: " + stateFlag);
    }

    private void serializeSnapshotPendingSplitsState(SnapshotPendingSplitsState state, DataOutputSerializer out) throws IOException {
        this.writeTableIds(state.getAlreadyProcessedTables(), out);
        this.writeRemainingSplits(state.getRemainingSplits(), out);
        this.writeAssignedSnapshotSplits(state.getAssignedSplits(), out);
        this.writeFinishedOffsets(state.getSplitFinishedOffsets(), out);
        out.writeInt(state.getSnapshotAssignerStatus().getStatusCode());
        this.writeTableIds(state.getRemainingTables(), out);
        out.writeBoolean(state.isTableIdCaseSensitive());
        MySqlSplitSerializer.writeTableSchemas(state.getTableSchemas(), out);
        boolean hasTableIsSplitting = state.getChunkSplitterState().getCurrentSplittingTableId() != null;
        out.writeBoolean(hasTableIsSplitting);
        if (hasTableIsSplitting) {
            ChunkSplitterState chunkSplitterState = state.getChunkSplitterState();
            out.writeUTF(chunkSplitterState.getCurrentSplittingTableId().toString());
            out.writeUTF(SerializerUtils.rowToSerializedString(new Object[]{chunkSplitterState.getNextChunkStart().getValue()}));
            out.writeInt(chunkSplitterState.getNextChunkId().intValue());
        }
    }

    private void serializeHybridPendingSplitsState(HybridPendingSplitsState state, DataOutputSerializer out) throws IOException {
        this.serializeSnapshotPendingSplitsState(state.getSnapshotPendingSplits(), out);
        out.writeBoolean(state.isBinlogSplitAssigned());
    }

    private void serializeBinlogPendingSplitsState(BinlogPendingSplitsState state, DataOutputSerializer out) throws IOException {
        out.writeBoolean(state.isBinlogSplitAssigned());
    }

    private SnapshotPendingSplitsState deserializeLegacySnapshotPendingSplitsState(int splitVersion, DataInputDeserializer in) throws IOException {
        List<TableId> alreadyProcessedTables = this.readTableIds(in);
        List<MySqlSnapshotSplit> remainingSplits = this.readMySqlSnapshotSplits(splitVersion, in);
        Map<String, MySqlSnapshotSplit> assignedSnapshotSplits = this.readAssignedSnapshotSplits(splitVersion, in);
        ArrayList<MySqlSchemalessSnapshotSplit> remainingSchemalessSplits = new ArrayList<MySqlSchemalessSnapshotSplit>();
        HashMap<String, MySqlSchemalessSnapshotSplit> assignedSchemalessSnapshotSplits = new HashMap<String, MySqlSchemalessSnapshotSplit>();
        HashMap<TableId, TableChanges.TableChange> tableSchemas = new HashMap<TableId, TableChanges.TableChange>();
        remainingSplits.forEach(split -> {
            tableSchemas.putAll(split.getTableSchemas());
            remainingSchemalessSplits.add(split.toSchemalessSnapshotSplit());
        });
        assignedSnapshotSplits.entrySet().forEach(entry -> {
            tableSchemas.putAll(((MySqlSnapshotSplit)entry.getValue()).getTableSchemas());
            assignedSchemalessSnapshotSplits.put((String)entry.getKey(), ((MySqlSnapshotSplit)entry.getValue()).toSchemalessSnapshotSplit());
        });
        Map<String, BinlogOffset> finishedOffsets = this.readFinishedOffsets(splitVersion, in);
        boolean isAssignerFinished = in.readBoolean();
        AssignerStatus assignerStatus = isAssignerFinished ? AssignerStatus.INITIAL_ASSIGNING_FINISHED : AssignerStatus.INITIAL_ASSIGNING;
        return new SnapshotPendingSplitsState(alreadyProcessedTables, remainingSchemalessSplits, assignedSchemalessSnapshotSplits, tableSchemas, finishedOffsets, assignerStatus, new ArrayList<TableId>(), false, false, ChunkSplitterState.NO_SPLITTING_TABLE_STATE);
    }

    private HybridPendingSplitsState deserializeLegacyHybridPendingSplitsState(int splitVersion, DataInputDeserializer in) throws IOException {
        SnapshotPendingSplitsState snapshotPendingSplitsState = this.deserializeLegacySnapshotPendingSplitsState(splitVersion, in);
        boolean isBinlogSplitAssigned = in.readBoolean();
        return new HybridPendingSplitsState(snapshotPendingSplitsState, isBinlogSplitAssigned);
    }

    private SnapshotPendingSplitsState deserializeSnapshotPendingSplitsState(int version, int splitVersion, DataInputDeserializer in) throws IOException {
        boolean hasTableIsSplitting;
        boolean isAssignerFinished;
        List<TableId> alreadyProcessedTables = this.readTableIds(in);
        List<MySqlSnapshotSplit> remainingSplits = this.readMySqlSnapshotSplits(splitVersion, in);
        Map<String, MySqlSnapshotSplit> assignedSnapshotSplits = this.readAssignedSnapshotSplits(splitVersion, in);
        Map<String, BinlogOffset> finishedOffsets = this.readFinishedOffsets(splitVersion, in);
        AssignerStatus assignerStatus = version >= 3 ? AssignerStatus.fromStatusCode(in.readInt()) : ((isAssignerFinished = in.readBoolean()) ? AssignerStatus.INITIAL_ASSIGNING_FINISHED : AssignerStatus.INITIAL_ASSIGNING);
        List<TableId> remainingTableIds = this.readTableIds(in);
        boolean isTableIdCaseSensitive = in.readBoolean();
        ArrayList<MySqlSchemalessSnapshotSplit> remainingSchemalessSplits = new ArrayList<MySqlSchemalessSnapshotSplit>();
        HashMap<String, MySqlSchemalessSnapshotSplit> assignedSchemalessSnapshotSplits = new HashMap<String, MySqlSchemalessSnapshotSplit>();
        HashMap<TableId, TableChanges.TableChange> tableSchemas = new HashMap<TableId, TableChanges.TableChange>();
        remainingSplits.forEach(split -> {
            tableSchemas.putAll(split.getTableSchemas());
            remainingSchemalessSplits.add(split.toSchemalessSnapshotSplit());
        });
        assignedSnapshotSplits.entrySet().forEach(entry -> {
            tableSchemas.putAll(((MySqlSnapshotSplit)entry.getValue()).getTableSchemas());
            assignedSchemalessSnapshotSplits.put((String)entry.getKey(), ((MySqlSnapshotSplit)entry.getValue()).toSchemalessSnapshotSplit());
        });
        if (version >= 4) {
            tableSchemas.putAll(MySqlSplitSerializer.readTableSchemas(splitVersion, in));
        }
        TableId splittingTableId = null;
        Object nextChunkStart = null;
        Integer nextChunkId = null;
        if (version > 4 && (hasTableIsSplitting = in.readBoolean())) {
            splittingTableId = TableId.parse(in.readUTF());
            nextChunkStart = SerializerUtils.serializedStringToRow(in.readUTF())[0];
            nextChunkId = in.readInt();
        }
        return new SnapshotPendingSplitsState(alreadyProcessedTables, remainingSchemalessSplits, assignedSchemalessSnapshotSplits, tableSchemas, finishedOffsets, assignerStatus, remainingTableIds, isTableIdCaseSensitive, true, splittingTableId == null ? ChunkSplitterState.NO_SPLITTING_TABLE_STATE : new ChunkSplitterState(splittingTableId, ChunkSplitterState.ChunkBound.middleOf(nextChunkStart), nextChunkId));
    }

    private HybridPendingSplitsState deserializeHybridPendingSplitsState(int version, int splitVersion, DataInputDeserializer in) throws IOException {
        SnapshotPendingSplitsState snapshotPendingSplitsState = this.deserializeSnapshotPendingSplitsState(version, splitVersion, in);
        boolean isBinlogSplitAssigned = in.readBoolean();
        return new HybridPendingSplitsState(snapshotPendingSplitsState, isBinlogSplitAssigned);
    }

    private BinlogPendingSplitsState deserializeBinlogPendingSplitsState(DataInputDeserializer in) throws IOException {
        return new BinlogPendingSplitsState(in.readBoolean());
    }

    private void writeFinishedOffsets(Map<String, BinlogOffset> splitsInfo, DataOutputSerializer out) throws IOException {
        int size = splitsInfo.size();
        out.writeInt(size);
        for (Map.Entry<String, BinlogOffset> splitInfo : splitsInfo.entrySet()) {
            out.writeUTF(splitInfo.getKey());
            SerializerUtils.writeBinlogPosition(splitInfo.getValue(), out);
        }
    }

    private Map<String, BinlogOffset> readFinishedOffsets(int offsetVersion, DataInputDeserializer in) throws IOException {
        HashMap<String, BinlogOffset> splitsInfo = new HashMap<String, BinlogOffset>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String splitId = in.readUTF();
            BinlogOffset binlogOffset = SerializerUtils.readBinlogPosition(offsetVersion, in);
            splitsInfo.put(splitId, binlogOffset);
        }
        return splitsInfo;
    }

    private void writeAssignedSnapshotSplits(Map<String, MySqlSchemalessSnapshotSplit> assignedSplits, DataOutputSerializer out) throws IOException {
        int size = assignedSplits.size();
        out.writeInt(size);
        for (Map.Entry<String, MySqlSchemalessSnapshotSplit> entry : assignedSplits.entrySet()) {
            out.writeUTF(entry.getKey());
            byte[] splitBytes = this.splitSerializer.serialize((Object)entry.getValue());
            out.writeInt(splitBytes.length);
            out.write(splitBytes);
        }
    }

    private Map<String, MySqlSnapshotSplit> readAssignedSnapshotSplits(int splitVersion, DataInputDeserializer in) throws IOException {
        HashMap<String, MySqlSnapshotSplit> assignedSplits = new HashMap<String, MySqlSnapshotSplit>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String splitId = in.readUTF();
            MySqlSnapshotSplit mySqlSplit = this.readMySqlSplit(splitVersion, in).asSnapshotSplit();
            assignedSplits.put(splitId, mySqlSplit);
        }
        return assignedSplits;
    }

    private <T extends MySqlSplit> void writeRemainingSplits(Collection<T> mySqlSplits, DataOutputSerializer out) throws IOException {
        int size = mySqlSplits.size();
        out.writeInt(size);
        for (MySqlSplit split : mySqlSplits) {
            byte[] splitBytes = this.splitSerializer.serialize((Object)split);
            out.writeInt(splitBytes.length);
            out.write(splitBytes);
        }
    }

    private List<MySqlSnapshotSplit> readMySqlSnapshotSplits(int splitVersion, DataInputDeserializer in) throws IOException {
        ArrayList<MySqlSnapshotSplit> mySqlSplits = new ArrayList<MySqlSnapshotSplit>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            MySqlSnapshotSplit mySqlSplit = this.readMySqlSplit(splitVersion, in).asSnapshotSplit();
            mySqlSplits.add(mySqlSplit);
        }
        return mySqlSplits;
    }

    private MySqlSplit readMySqlSplit(int splitVersion, DataInputDeserializer in) throws IOException {
        int splitBytesLen = in.readInt();
        byte[] splitBytes = new byte[splitBytesLen];
        in.read(splitBytes);
        return (MySqlSplit)this.splitSerializer.deserialize(splitVersion, splitBytes);
    }

    private void writeTableIds(Collection<TableId> tableIds, DataOutputSerializer out) throws IOException {
        int size = tableIds.size();
        out.writeInt(size);
        for (TableId tableId : tableIds) {
            out.writeUTF(tableId.toString());
        }
    }

    private List<TableId> readTableIds(DataInputDeserializer in) throws IOException {
        ArrayList<TableId> tableIds = new ArrayList<TableId>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String tableIdStr = in.readUTF();
            tableIds.add(TableId.parse(tableIdStr));
        }
        return tableIds;
    }
}

