/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source;

import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.annotation.VisibleForTesting;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.common.source.DataSource;
import org.apache.flink.cdc.common.source.EventSourceProvider;
import org.apache.flink.cdc.common.source.FlinkSourceProvider;
import org.apache.flink.cdc.common.source.MetadataAccessor;
import org.apache.flink.cdc.connectors.mysql.source.MySqlEventDeserializer;
import org.apache.flink.cdc.connectors.mysql.source.MySqlMetadataAccessor;
import org.apache.flink.cdc.connectors.mysql.source.MySqlSource;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfigFactory;
import org.apache.flink.cdc.connectors.mysql.source.reader.MySqlPipelineRecordEmitter;
import org.apache.flink.cdc.debezium.table.DebeziumChangelogMode;

@Internal
public class MySqlDataSource
implements DataSource {
    private final MySqlSourceConfigFactory configFactory;
    private final MySqlSourceConfig sourceConfig;

    public MySqlDataSource(MySqlSourceConfigFactory configFactory) {
        this.configFactory = configFactory;
        this.sourceConfig = configFactory.createConfig(0);
    }

    public EventSourceProvider getEventSourceProvider() {
        MySqlEventDeserializer deserializer = new MySqlEventDeserializer(DebeziumChangelogMode.ALL, this.sourceConfig.isIncludeSchemaChanges());
        MySqlSource<Event> source = new MySqlSource<Event>(this.configFactory, deserializer, (sourceReaderMetrics, sourceConfig) -> new MySqlPipelineRecordEmitter(deserializer, sourceReaderMetrics, sourceConfig));
        return FlinkSourceProvider.of(source);
    }

    public MetadataAccessor getMetadataAccessor() {
        return new MySqlMetadataAccessor(this.sourceConfig);
    }

    @VisibleForTesting
    public MySqlSourceConfig getSourceConfig() {
        return this.sourceConfig;
    }
}

