/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.converters;

import io.debezium.spi.converter.CustomConverter;
import io.debezium.spi.converter.RelationalColumn;
import io.debezium.time.Conversions;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.flink.cdc.debezium.utils.ConvertTimeBceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlDebeziumTimeConverter
implements CustomConverter<SchemaBuilder, RelationalColumn> {
    private static final Logger log = LoggerFactory.getLogger(MysqlDebeziumTimeConverter.class);
    private static boolean loggedUnknownTimestampClass = false;
    private static boolean loggedUnknownDateClass = false;
    private static boolean loggedUnknownTimeClass = false;
    private static boolean loggedUnknownTimestampWithTimeZoneClass = false;
    private final String DATE = "DATE";
    private final String DATETIME = "DATETIME";
    private final String TIME = "TIME";
    private final String TIMESTAMP = "TIMESTAMP";
    private final String[] DATE_TYPES = new String[]{"DATE", "DATETIME", "TIME", "TIMESTAMP"};
    protected static final String DATE_FORMAT = "yyyy-MM-dd";
    protected static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    protected static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    protected ZoneId zoneId;
    protected static final String DEFAULT_DATE_FORMAT_PATTERN = "1970-01-01 00:00:00";
    protected DateTimeFormatter dateFormatter;
    protected DateTimeFormatter timeFormatter;
    protected DateTimeFormatter datetimeFormatter;
    protected DateTimeFormatter timestampFormatter;
    protected String schemaNamePrefix;
    protected static DateTimeFormatter originalFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    protected Boolean parseNullDefaultValue = true;

    @Override
    public void configure(Properties properties) {
        String dateFormat = properties.getProperty("format.date", DATE_FORMAT);
        String timeFormat = properties.getProperty("format.time", "yyyy-MM-dd HH:mm:ss");
        String datetimeFormat = properties.getProperty("format.datetime", "yyyy-MM-dd HH:mm:ss");
        String timestampFormat = properties.getProperty("format.timestamp", "yyyy-MM-dd HH:mm:ss");
        this.parseNullDefaultValue = Boolean.parseBoolean(properties.getProperty("format.default.value.convert", "true"));
        String className = this.getClass().getName();
        this.schemaNamePrefix = properties.getProperty("schema.name.prefix", className + ".mysql");
        this.dateFormatter = DateTimeFormatter.ofPattern(dateFormat);
        this.timeFormatter = DateTimeFormatter.ofPattern(timeFormat);
        this.datetimeFormatter = DateTimeFormatter.ofPattern(datetimeFormat);
        this.timestampFormatter = DateTimeFormatter.ofPattern(timestampFormat);
        this.zoneId = ZoneId.of(properties.getProperty("format.timezone", ZoneId.systemDefault().toString()));
    }

    @Override
    public void converterFor(RelationalColumn field, CustomConverter.ConverterRegistration<SchemaBuilder> registration) {
        if (Arrays.stream(this.DATE_TYPES).anyMatch(s -> s.equalsIgnoreCase(field.typeName()))) {
            this.registerDateConverter(field, registration);
        }
    }

    private void registerDateConverter(RelationalColumn field, CustomConverter.ConverterRegistration<SchemaBuilder> registration) {
        String columnType = field.typeName().toUpperCase();
        String schemaName = this.schemaNamePrefix + "." + columnType.toLowerCase();
        registration.register(SchemaBuilder.string().name(schemaName).optional(), value -> {
            log.debug("find schema need to change dateType, field name:{} ,field type:{} ,field value:{} ,field default:{}", new Object[]{field.name(), columnType, value == null ? "null" : value, field.hasDefaultValue() ? field.defaultValue() : "null"});
            if (value == null) {
                return this.convertDateDefaultValue(field);
            }
            switch (columnType.toUpperCase(Locale.ROOT)) {
                case "DATE": {
                    if (value instanceof Integer) {
                        return this.convertToDate(columnType, LocalDate.ofEpochDay(((Integer)value).intValue()));
                    }
                    return this.convertToDate(columnType, value);
                }
                case "TIME": {
                    if (value instanceof Long) {
                        long l = Math.multiplyExact((long)((Long)value), TimeUnit.MICROSECONDS.toNanos(1L));
                        return this.convertToTime(columnType, LocalTime.ofNanoOfDay(l));
                    }
                    return this.convertToTime(columnType, value);
                }
                case "DATETIME": {
                    if (value instanceof Long) {
                        if (this.getTimePrecision(field) <= 3) {
                            return this.convertToTimestamp(columnType, Conversions.toInstantFromMillis((Long)value));
                        }
                        if (this.getTimePrecision(field) <= 6) {
                            return this.convertToTimestamp(columnType, Conversions.toInstantFromMicros((Long)value));
                        }
                    }
                    return this.convertToTimestamp(columnType, value);
                }
                case "TIMESTAMP": {
                    return this.convertToTimestampWithTimezone(columnType, value);
                }
            }
            throw new IllegalArgumentException("Unknown field type  " + columnType.toUpperCase(Locale.ROOT));
        });
    }

    private Object convertToTimestampWithTimezone(String columnType, Object timestamp) {
        if (timestamp instanceof Timestamp) {
            Timestamp value = (Timestamp)timestamp;
            ZonedDateTime zonedDateTime = value.toInstant().atZone(this.zoneId);
            return ConvertTimeBceUtil.resolveEra(value, zonedDateTime.format(this.timestampFormatter));
        }
        if (timestamp instanceof OffsetDateTime) {
            OffsetDateTime value = (OffsetDateTime)timestamp;
            return ConvertTimeBceUtil.resolveEra(value.toLocalDate(), value.format(this.timestampFormatter));
        }
        if (timestamp instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)timestamp;
            return ConvertTimeBceUtil.resolveEra(zonedDateTime.toLocalDate(), zonedDateTime.format(this.timestampFormatter));
        }
        if (timestamp instanceof Instant) {
            OffsetDateTime dateTime = OffsetDateTime.ofInstant((Instant)timestamp, this.zoneId);
            ZonedDateTime timestampZt = ZonedDateTime.from(dateTime);
            LocalDate localDate = timestampZt.toLocalDate();
            return ConvertTimeBceUtil.resolveEra(localDate, timestampZt.format(this.timestampFormatter));
        }
        if (!loggedUnknownTimestampWithTimeZoneClass) {
            MysqlDebeziumTimeConverter.printUnknownDateClassLogs(columnType, timestamp);
            loggedUnknownTimestampWithTimeZoneClass = true;
        }
        Instant instant = Instant.parse(timestamp.toString());
        OffsetDateTime dateTime = OffsetDateTime.ofInstant(instant, this.zoneId);
        ZonedDateTime timestampZt = ZonedDateTime.from(dateTime);
        LocalDate localDate = timestampZt.toLocalDate();
        return ConvertTimeBceUtil.resolveEra(localDate, timestampZt.format(this.timestampFormatter));
    }

    private Object convertToTimestamp(String columnType, Object timestamp) {
        if (timestamp instanceof Timestamp) {
            LocalDateTime localDateTime = ((Timestamp)timestamp).toLocalDateTime();
            return ConvertTimeBceUtil.resolveEra((Timestamp)timestamp, localDateTime.format(this.datetimeFormatter));
        }
        if (timestamp instanceof Instant) {
            Instant time = (Instant)timestamp;
            ZonedDateTime zonedDateTime = time.atZone(this.zoneId);
            return ConvertTimeBceUtil.resolveEra(zonedDateTime.toLocalDate(), time.atOffset(zonedDateTime.getOffset()).toLocalDateTime().format(this.datetimeFormatter));
        }
        if (timestamp instanceof LocalDateTime) {
            LocalDateTime dateTime = (LocalDateTime)timestamp;
            LocalDate localDateTime = dateTime.toLocalDate();
            return ConvertTimeBceUtil.resolveEra(localDateTime, dateTime.format(this.datetimeFormatter));
        }
        if (!loggedUnknownTimestampClass) {
            MysqlDebeziumTimeConverter.printUnknownDateClassLogs(columnType, timestamp);
            loggedUnknownTimestampClass = true;
        }
        LocalDateTime localDateTime = LocalDateTime.parse(timestamp.toString());
        LocalDate localDate = localDateTime.toLocalDate();
        return ConvertTimeBceUtil.resolveEra(localDate, localDateTime.format(this.datetimeFormatter));
    }

    private Object convertToTime(String columnType, Object time) {
        String valueAsString;
        if (time instanceof Time) {
            return this.formatTime(((Time)time).toLocalTime());
        }
        if (time instanceof LocalTime) {
            return this.formatTime((LocalTime)time);
        }
        if (time instanceof Duration) {
            long value = ((Duration)time).toNanos();
            if (value >= 0L && value < TimeUnit.DAYS.toNanos(1L)) {
                return this.formatTime(LocalTime.ofNanoOfDay(value));
            }
            long updatedValue = Math.min(Math.abs(value), LocalTime.MAX.toNanoOfDay());
            log.debug("Time values must use number of nanoseconds greater than 0 and less than 86400000000000 but its {}, converting to {} ", (Object)value, (Object)updatedValue);
            return this.formatTime(LocalTime.ofNanoOfDay(updatedValue));
        }
        if (!loggedUnknownTimeClass) {
            MysqlDebeziumTimeConverter.printUnknownDateClassLogs(columnType, time);
            loggedUnknownTimeClass = true;
        }
        if ((valueAsString = time.toString()).startsWith("24")) {
            log.debug("Time value {} is above range, converting to 23:59:59", (Object)valueAsString);
            return LocalTime.MAX.toString();
        }
        return this.formatTime(LocalTime.parse(valueAsString));
    }

    private String formatTime(LocalTime localTime) {
        return localTime.format(this.timeFormatter);
    }

    private int getTimePrecision(RelationalColumn field) {
        return field.length().orElse(-1);
    }

    private String convertToDate(String columnType, Object date) {
        if (date instanceof Date) {
            LocalDate localDate = ((Date)date).toLocalDate();
            return ConvertTimeBceUtil.resolveEra(localDate, localDate.format(this.dateFormatter));
        }
        if (date instanceof LocalDate) {
            return this.dateFormatter.format((LocalDate)date);
        }
        if (date instanceof LocalDateTime) {
            return this.datetimeFormatter.format((LocalDateTime)date);
        }
        if (date instanceof Integer) {
            return LocalDate.ofEpochDay(((Integer)date).longValue()).format(this.dateFormatter);
        }
        if (!loggedUnknownDateClass) {
            MysqlDebeziumTimeConverter.printUnknownDateClassLogs(columnType, date);
            loggedUnknownDateClass = true;
        }
        LocalDate localDate = LocalDate.parse(date.toString());
        return ConvertTimeBceUtil.resolveEra(localDate, localDate.format(this.dateFormatter));
    }

    public Object convertDateDefaultValue(RelationalColumn field) {
        if (field.isOptional()) {
            return null;
        }
        if (field.hasDefaultValue() && this.parseNullDefaultValue.booleanValue()) {
            LocalDateTime dateTime = LocalDateTime.parse(DEFAULT_DATE_FORMAT_PATTERN, originalFormat);
            String columnType = field.typeName().toUpperCase();
            switch (columnType.toUpperCase(Locale.ROOT)) {
                case "DATE": {
                    return dateTime.format(this.dateFormatter);
                }
                case "DATETIME": {
                    return dateTime.format(this.datetimeFormatter);
                }
                case "TIME": {
                    return dateTime.format(this.timeFormatter);
                }
                case "TIMESTAMP": {
                    return dateTime.format(this.timestampFormatter);
                }
            }
        }
        return null;
    }

    private static void printUnknownDateClassLogs(String type, Object value) {
        log.warn("MySql Date Convert Database type : {} Unknown class for Date data type {}", (Object)type, value.getClass());
    }
}

