/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.testutils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.cdc.common.event.CreateTableEvent;

public class MySqSourceTestUtils {
    public static final String TEST_USER = "mysqluser";
    public static final String TEST_PASSWORD = "mysqlpw";

    public static <T> List<T> fetchResults(Iterator<T> iter, int size) {
        ArrayList<T> result = new ArrayList<T>(size);
        while (size > 0 && iter.hasNext()) {
            T event = iter.next();
            result.add(event);
            --size;
        }
        return result;
    }

    public static <T> Tuple2<List<T>, List<CreateTableEvent>> fetchResultsAndCreateTableEvent(Iterator<T> iter, int size) {
        ArrayList<T> result = new ArrayList<T>(size);
        ArrayList<CreateTableEvent> createTableEvents = new ArrayList<CreateTableEvent>();
        while (size > 0 && iter.hasNext()) {
            T event = iter.next();
            if (event instanceof CreateTableEvent) {
                createTableEvents.add((CreateTableEvent)event);
                continue;
            }
            result.add(event);
            --size;
        }
        return Tuple2.of(result, createTableEvents);
    }

    public static String getServerId(int parallelism) {
        Random random = new Random();
        int serverId = random.nextInt(100) + 5400;
        return serverId + "-" + (serverId + parallelism);
    }

    private MySqSourceTestUtils() {
    }
}

