/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypes;
import org.apache.flink.cdc.common.types.RowType;
import org.apache.flink.cdc.connectors.mysql.source.MySqlMetadataAccessor;
import org.apache.flink.cdc.connectors.mysql.source.MySqlSourceTestBase;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfigFactory;
import org.apache.flink.cdc.connectors.mysql.table.StartupOptions;
import org.apache.flink.cdc.connectors.mysql.testutils.MySqlContainer;
import org.apache.flink.cdc.connectors.mysql.testutils.MySqlVersion;
import org.apache.flink.cdc.connectors.mysql.testutils.UniqueDatabase;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testcontainers.lifecycle.Startables;

public class MySqlMetadataAccessorITCase
extends MySqlSourceTestBase {
    private static final MySqlContainer MYSQL8_CONTAINER = MySqlMetadataAccessorITCase.createMySqlContainer((MySqlVersion)MySqlVersion.V8_0, (String)"docker/server-gtids/expire-seconds/my.cnf");
    private final UniqueDatabase fullTypesMySql57Database = new UniqueDatabase(MYSQL_CONTAINER, "column_type_test", "mysqluser", "mysqlpw");
    private final UniqueDatabase fullTypesMySql8Database = new UniqueDatabase(MYSQL8_CONTAINER, "column_type_test_mysql8", "mysqluser", "mysqlpw");
    private final StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();

    @BeforeClass
    public static void beforeClass() {
        LOG.info("Starting MySql8 containers...");
        Startables.deepStart(Stream.of(MYSQL8_CONTAINER)).join();
        LOG.info("Container MySql8 is started.");
    }

    @AfterClass
    public static void afterClass() {
        LOG.info("Stopping MySql8 containers...");
        MYSQL8_CONTAINER.stop();
        LOG.info("Container MySql8 is stopped.");
    }

    @Before
    public void before() {
        this.env.setParallelism(4);
        this.env.enableCheckpointing(200L);
        this.env.setRestartStrategy(RestartStrategies.noRestart());
    }

    @Test
    public void testMysql57AccessDatabaseAndTable() {
        this.testAccessDatabaseAndTable(this.fullTypesMySql57Database);
    }

    @Test
    public void testMysql8AccessDatabaseAndTable() {
        this.testAccessDatabaseAndTable(this.fullTypesMySql8Database);
    }

    @Test
    public void testMysql57AccessCommonTypesSchema() {
        this.testAccessCommonTypesSchema(this.fullTypesMySql57Database);
    }

    @Test
    public void testMysql8AccessCommonTypesSchema() {
        this.testAccessCommonTypesSchema(this.fullTypesMySql8Database);
    }

    @Test
    public void testMysql57AccessTimeTypesSchema() {
        this.fullTypesMySql57Database.createAndInitialize();
        String[] tables = new String[]{"time_types"};
        MySqlMetadataAccessor metadataAccessor = this.getMetadataAccessor(tables, this.fullTypesMySql57Database);
        Schema actualSchema = metadataAccessor.getTableSchema(TableId.tableId((String)this.fullTypesMySql57Database.getDatabaseName(), (String)"time_types"));
        Schema expectedSchema = Schema.newBuilder().primaryKey(new String[]{"id"}).fromRowDataType((DataType)RowType.of((DataType[])new DataType[]{DataTypes.DECIMAL((int)20, (int)0).notNull(), DataTypes.INT(), DataTypes.DATE(), DataTypes.TIME((int)0), DataTypes.TIME((int)3), DataTypes.TIME((int)6), DataTypes.TIMESTAMP((int)0), DataTypes.TIMESTAMP((int)3), DataTypes.TIMESTAMP((int)6), DataTypes.TIMESTAMP_LTZ((int)0), DataTypes.TIMESTAMP_LTZ((int)0)}, (String[])new String[]{"id", "year_c", "date_c", "time_c", "time_3_c", "time_6_c", "datetime_c", "datetime3_c", "datetime6_c", "timestamp_c", "timestamp_def_c"})).build();
        Assertions.assertThat((Object)actualSchema).isEqualTo((Object)expectedSchema);
    }

    @Test
    public void testMysql8AccessTimeTypesSchema() {
        this.fullTypesMySql8Database.createAndInitialize();
        String[] tables = new String[]{"time_types"};
        MySqlMetadataAccessor metadataAccessor = this.getMetadataAccessor(tables, this.fullTypesMySql8Database);
        Schema actualSchema = metadataAccessor.getTableSchema(TableId.tableId((String)this.fullTypesMySql8Database.getDatabaseName(), (String)"time_types"));
        Schema expectedSchema = Schema.newBuilder().primaryKey(new String[]{"id"}).fromRowDataType((DataType)RowType.of((DataType[])new DataType[]{DataTypes.DECIMAL((int)20, (int)0).notNull(), DataTypes.INT(), DataTypes.DATE(), DataTypes.TIME((int)0), DataTypes.TIME((int)3), DataTypes.TIME((int)6), DataTypes.TIMESTAMP((int)0), DataTypes.TIMESTAMP((int)3), DataTypes.TIMESTAMP((int)6), DataTypes.TIMESTAMP_LTZ((int)0), DataTypes.TIMESTAMP_LTZ((int)3), DataTypes.TIMESTAMP_LTZ((int)6), DataTypes.TIMESTAMP_LTZ((int)0)}, (String[])new String[]{"id", "year_c", "date_c", "time_c", "time_3_c", "time_6_c", "datetime_c", "datetime3_c", "datetime6_c", "timestamp_c", "timestamp3_c", "timestamp6_c", "timestamp_def_c"})).build();
        Assertions.assertThat((Object)actualSchema).isEqualTo((Object)expectedSchema);
    }

    private void testAccessDatabaseAndTable(UniqueDatabase database) {
        database.createAndInitialize();
        String[] tables = new String[]{"common_types", "time_types", "precision_types"};
        MySqlMetadataAccessor metadataAccessor = this.getMetadataAccessor(tables, database);
        Assertions.assertThatThrownBy(() -> ((MySqlMetadataAccessor)metadataAccessor).listNamespaces()).isInstanceOf(UnsupportedOperationException.class);
        List schemas = metadataAccessor.listSchemas(null);
        Assertions.assertThat((List)schemas).contains((Object[])new String[]{database.getDatabaseName()});
        List actualTables = metadataAccessor.listTables(null, database.getDatabaseName());
        List expectedTables = Arrays.stream(tables).map(table -> TableId.tableId((String)database.getDatabaseName(), (String)table)).collect(Collectors.toList());
        Assertions.assertThat((List)actualTables).containsExactlyInAnyOrderElementsOf(expectedTables);
    }

    private void testAccessCommonTypesSchema(UniqueDatabase database) {
        database.createAndInitialize();
        String[] tables = new String[]{"common_types"};
        MySqlMetadataAccessor metadataAccessor = this.getMetadataAccessor(tables, database);
        Schema actualSchema = metadataAccessor.getTableSchema(TableId.tableId((String)database.getDatabaseName(), (String)"common_types"));
        Schema expectedSchema = Schema.newBuilder().primaryKey(new String[]{"id"}).fromRowDataType((DataType)RowType.of((DataType[])new DataType[]{DataTypes.DECIMAL((int)20, (int)0).notNull(), DataTypes.TINYINT(), DataTypes.SMALLINT(), DataTypes.SMALLINT(), DataTypes.SMALLINT(), DataTypes.INT(), DataTypes.INT(), DataTypes.INT(), DataTypes.INT(), DataTypes.INT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.BIGINT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.DECIMAL((int)20, (int)0), DataTypes.DECIMAL((int)20, (int)0), DataTypes.VARCHAR((int)255), DataTypes.CHAR((int)3), DataTypes.DOUBLE(), DataTypes.FLOAT(), DataTypes.FLOAT(), DataTypes.FLOAT(), DataTypes.DOUBLE(), DataTypes.DOUBLE(), DataTypes.DOUBLE(), DataTypes.DECIMAL((int)8, (int)4), DataTypes.DECIMAL((int)8, (int)4), DataTypes.DECIMAL((int)8, (int)4), DataTypes.DECIMAL((int)6, (int)0), DataTypes.STRING(), DataTypes.BOOLEAN(), DataTypes.BINARY((int)1), DataTypes.BOOLEAN(), DataTypes.BOOLEAN(), DataTypes.BINARY((int)16), DataTypes.BINARY((int)8), DataTypes.STRING(), DataTypes.BYTES(), DataTypes.BYTES(), DataTypes.BYTES(), DataTypes.BYTES(), DataTypes.INT(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}, (String[])new String[]{"id", "tiny_c", "tiny_un_c", "tiny_un_z_c", "small_c", "small_un_c", "small_un_z_c", "medium_c", "medium_un_c", "medium_un_z_c", "int_c", "int_un_c", "int_un_z_c", "int11_c", "big_c", "big_un_c", "big_un_z_c", "varchar_c", "char_c", "real_c", "float_c", "float_un_c", "float_un_z_c", "double_c", "double_un_c", "double_un_z_c", "decimal_c", "decimal_un_c", "decimal_un_z_c", "numeric_c", "big_decimal_c", "bit1_c", "bit3_c", "tiny1_c", "boolean_c", "file_uuid", "bit_c", "text_c", "tiny_blob_c", "blob_c", "medium_blob_c", "long_blob_c", "year_c", "enum_c", "json_c", "point_c", "geometry_c", "linestring_c", "polygon_c", "multipoint_c", "multiline_c", "multipolygon_c", "geometrycollection_c"})).build();
        Assertions.assertThat((Object)actualSchema).isEqualTo((Object)expectedSchema);
    }

    private MySqlMetadataAccessor getMetadataAccessor(String[] tables, UniqueDatabase database) {
        MySqlSourceConfig sourceConfig = this.getConfig(tables, database);
        return new MySqlMetadataAccessor(sourceConfig);
    }

    private MySqlSourceConfig getConfig(String[] captureTables, UniqueDatabase database) {
        String[] captureTableIds = (String[])Arrays.stream(captureTables).map(tableName -> database.getDatabaseName() + "." + tableName).toArray(String[]::new);
        return new MySqlSourceConfigFactory().startupOptions(StartupOptions.latest()).databaseList(new String[]{database.getDatabaseName()}).tableList(captureTableIds).includeSchemaChanges(false).hostname(database.getHost()).port(database.getDatabasePort()).splitSize(10).fetchSize(2).username(database.getUsername()).password(database.getPassword()).serverTimeZone(ZoneId.of("UTC").toString()).createConfig(0);
    }
}

