/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.cdc.common.configuration.ConfigOption;
import org.apache.flink.cdc.common.configuration.Configuration;
import org.apache.flink.cdc.common.factories.Factory;
import org.apache.flink.cdc.connectors.mysql.factory.MySqlDataSourceFactory;
import org.apache.flink.cdc.connectors.mysql.source.MySqlDataSource;
import org.apache.flink.cdc.connectors.mysql.source.MySqlDataSourceOptions;
import org.apache.flink.cdc.connectors.mysql.source.MySqlSourceTestBase;
import org.apache.flink.cdc.connectors.mysql.testutils.UniqueDatabase;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ObjectPath;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.junit.Test;

public class MySqlDataSourceFactoryTest
extends MySqlSourceTestBase {
    private final UniqueDatabase inventoryDatabase = new UniqueDatabase(MYSQL_CONTAINER, "inventory", "mysqluser", "mysqlpw");

    @Test
    public void testCreateSource() {
        this.inventoryDatabase.createAndInitialize();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(MySqlDataSourceOptions.HOSTNAME.key(), MYSQL_CONTAINER.getHost());
        options.put(MySqlDataSourceOptions.PORT.key(), String.valueOf(MYSQL_CONTAINER.getDatabasePort()));
        options.put(MySqlDataSourceOptions.USERNAME.key(), "mysqluser");
        options.put(MySqlDataSourceOptions.PASSWORD.key(), "mysqlpw");
        options.put(MySqlDataSourceOptions.TABLES.key(), this.inventoryDatabase.getDatabaseName() + ".prod\\.*");
        MockContext context = new MockContext(Configuration.fromMap(options));
        MySqlDataSourceFactory factory = new MySqlDataSourceFactory();
        MySqlDataSource dataSource = (MySqlDataSource)factory.createDataSource((Factory.Context)context);
        Assertions.assertThat((List)dataSource.getSourceConfig().getTableList()).isEqualTo(Arrays.asList(this.inventoryDatabase.getDatabaseName() + ".products"));
    }

    @Test
    public void testNoMatchedTable() {
        this.inventoryDatabase.createAndInitialize();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(MySqlDataSourceOptions.HOSTNAME.key(), MYSQL_CONTAINER.getHost());
        options.put(MySqlDataSourceOptions.PORT.key(), String.valueOf(MYSQL_CONTAINER.getDatabasePort()));
        options.put(MySqlDataSourceOptions.USERNAME.key(), "mysqluser");
        options.put(MySqlDataSourceOptions.PASSWORD.key(), "mysqlpw");
        String tables = this.inventoryDatabase.getDatabaseName() + ".test";
        options.put(MySqlDataSourceOptions.TABLES.key(), tables);
        MockContext context = new MockContext(Configuration.fromMap(options));
        MySqlDataSourceFactory factory = new MySqlDataSourceFactory();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> factory.createDataSource(context)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot find any table by the option 'tables' = " + tables);
    }

    @Test
    public void testExcludeTable() {
        this.inventoryDatabase.createAndInitialize();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(MySqlDataSourceOptions.HOSTNAME.key(), MYSQL_CONTAINER.getHost());
        options.put(MySqlDataSourceOptions.PORT.key(), String.valueOf(MYSQL_CONTAINER.getDatabasePort()));
        options.put(MySqlDataSourceOptions.USERNAME.key(), "mysqluser");
        options.put(MySqlDataSourceOptions.PASSWORD.key(), "mysqlpw");
        options.put(MySqlDataSourceOptions.TABLES.key(), this.inventoryDatabase.getDatabaseName() + ".\\.*");
        String tableExclude = this.inventoryDatabase.getDatabaseName() + ".orders";
        options.put(MySqlDataSourceOptions.TABLES_EXCLUDE.key(), tableExclude);
        MockContext context = new MockContext(Configuration.fromMap(options));
        MySqlDataSourceFactory factory = new MySqlDataSourceFactory();
        MySqlDataSource dataSource = (MySqlDataSource)factory.createDataSource((Factory.Context)context);
        ((ListAssert)Assertions.assertThat((List)dataSource.getSourceConfig().getTableList()).isNotEqualTo(Arrays.asList(this.inventoryDatabase.getDatabaseName() + ".orders"))).isEqualTo(Arrays.asList(this.inventoryDatabase.getDatabaseName() + ".customers", this.inventoryDatabase.getDatabaseName() + ".multi_max_table", this.inventoryDatabase.getDatabaseName() + ".products"));
    }

    @Test
    public void testExcludeAllTable() {
        this.inventoryDatabase.createAndInitialize();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(MySqlDataSourceOptions.HOSTNAME.key(), MYSQL_CONTAINER.getHost());
        options.put(MySqlDataSourceOptions.PORT.key(), String.valueOf(MYSQL_CONTAINER.getDatabasePort()));
        options.put(MySqlDataSourceOptions.USERNAME.key(), "mysqluser");
        options.put(MySqlDataSourceOptions.PASSWORD.key(), "mysqlpw");
        options.put(MySqlDataSourceOptions.TABLES.key(), this.inventoryDatabase.getDatabaseName() + ".prod\\.*");
        String tableExclude = this.inventoryDatabase.getDatabaseName() + ".prod\\.*";
        options.put(MySqlDataSourceOptions.TABLES_EXCLUDE.key(), tableExclude);
        MockContext context = new MockContext(Configuration.fromMap(options));
        MySqlDataSourceFactory factory = new MySqlDataSourceFactory();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> factory.createDataSource(context)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot find any table with by the option 'tables.exclude'  = " + tableExclude);
    }

    @Test
    public void testDatabaseAndTableWithTheSameName() throws SQLException {
        this.inventoryDatabase.createAndInitialize();
        try (Connection connection = this.inventoryDatabase.getJdbcConnection();
             Statement statement = connection.createStatement();){
            String createSameNameTableSql = String.format("CREATE TABLE IF NOT EXISTS `%s`.`%s` (\n  id INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,\n  name VARCHAR(255) NOT NULL DEFAULT 'flink',\n  description VARCHAR(512)\n);", this.inventoryDatabase.getDatabaseName(), this.inventoryDatabase.getDatabaseName());
            statement.execute(createSameNameTableSql);
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(MySqlDataSourceOptions.HOSTNAME.key(), MYSQL_CONTAINER.getHost());
        options.put(MySqlDataSourceOptions.PORT.key(), String.valueOf(MYSQL_CONTAINER.getDatabasePort()));
        options.put(MySqlDataSourceOptions.USERNAME.key(), "mysqluser");
        options.put(MySqlDataSourceOptions.PASSWORD.key(), "mysqlpw");
        options.put(MySqlDataSourceOptions.TABLES.key(), this.inventoryDatabase.getDatabaseName() + "." + this.inventoryDatabase.getDatabaseName());
        MockContext context = new MockContext(Configuration.fromMap(options));
        MySqlDataSourceFactory factory = new MySqlDataSourceFactory();
        MySqlDataSource dataSource = (MySqlDataSource)factory.createDataSource((Factory.Context)context);
        Assertions.assertThat((List)dataSource.getSourceConfig().getTableList()).isEqualTo(Arrays.asList(this.inventoryDatabase.getDatabaseName() + "." + this.inventoryDatabase.getDatabaseName()));
    }

    @Test
    public void testLackRequireOption() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(MySqlDataSourceOptions.HOSTNAME.key(), MYSQL_CONTAINER.getHost());
        options.put(MySqlDataSourceOptions.PORT.key(), String.valueOf(MYSQL_CONTAINER.getDatabasePort()));
        options.put(MySqlDataSourceOptions.USERNAME.key(), "mysqluser");
        options.put(MySqlDataSourceOptions.PASSWORD.key(), "mysqlpw");
        options.put(MySqlDataSourceOptions.TABLES.key(), this.inventoryDatabase.getDatabaseName() + ".prod\\.*");
        MySqlDataSourceFactory factory = new MySqlDataSourceFactory();
        List requireKeys = factory.requiredOptions().stream().map(ConfigOption::key).collect(Collectors.toList());
        for (String requireKey : requireKeys) {
            HashMap remainingOptions = new HashMap(options);
            remainingOptions.remove(requireKey);
            MockContext context = new MockContext(Configuration.fromMap(remainingOptions));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> factory.createDataSource(context)).isInstanceOf(ValidationException.class)).hasMessageContaining(String.format("One or more required options are missing.\n\nMissing required options are:\n\n%s", requireKey));
        }
    }

    @Test
    public void testUnsupportedOption() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(MySqlDataSourceOptions.HOSTNAME.key(), MYSQL_CONTAINER.getHost());
        options.put(MySqlDataSourceOptions.PORT.key(), String.valueOf(MYSQL_CONTAINER.getDatabasePort()));
        options.put(MySqlDataSourceOptions.USERNAME.key(), "mysqluser");
        options.put(MySqlDataSourceOptions.PASSWORD.key(), "mysqlpw");
        options.put(MySqlDataSourceOptions.TABLES.key(), this.inventoryDatabase.getDatabaseName() + ".prod\\.*");
        options.put("unsupported_key", "unsupported_value");
        MySqlDataSourceFactory factory = new MySqlDataSourceFactory();
        MockContext context = new MockContext(Configuration.fromMap(options));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> factory.createDataSource(context)).isInstanceOf(ValidationException.class)).hasMessageContaining("Unsupported options found for 'mysql'.\n\nUnsupported options:\n\nunsupported_key");
    }

    @Test
    public void testPrefixRequireOption() {
        this.inventoryDatabase.createAndInitialize();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(MySqlDataSourceOptions.HOSTNAME.key(), MYSQL_CONTAINER.getHost());
        options.put(MySqlDataSourceOptions.PORT.key(), String.valueOf(MYSQL_CONTAINER.getDatabasePort()));
        options.put(MySqlDataSourceOptions.USERNAME.key(), "mysqluser");
        options.put(MySqlDataSourceOptions.PASSWORD.key(), "mysqlpw");
        options.put(MySqlDataSourceOptions.TABLES.key(), this.inventoryDatabase.getDatabaseName() + ".prod\\.*");
        options.put("jdbc.properties.requireSSL", "true");
        options.put("debezium.snapshot.mode", "initial");
        MockContext context = new MockContext(Configuration.fromMap(options));
        MySqlDataSourceFactory factory = new MySqlDataSourceFactory();
        MySqlDataSource dataSource = (MySqlDataSource)factory.createDataSource((Factory.Context)context);
        Assertions.assertThat((List)dataSource.getSourceConfig().getTableList()).isEqualTo(Arrays.asList(this.inventoryDatabase.getDatabaseName() + ".products"));
    }

    @Test
    public void testAddChunkKeyColumns() {
        this.inventoryDatabase.createAndInitialize();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(MySqlDataSourceOptions.HOSTNAME.key(), MYSQL_CONTAINER.getHost());
        options.put(MySqlDataSourceOptions.PORT.key(), String.valueOf(MYSQL_CONTAINER.getDatabasePort()));
        options.put(MySqlDataSourceOptions.USERNAME.key(), "mysqluser");
        options.put(MySqlDataSourceOptions.PASSWORD.key(), "mysqlpw");
        options.put(MySqlDataSourceOptions.TABLES.key(), this.inventoryDatabase.getDatabaseName() + ".\\.*");
        options.put(MySqlDataSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_KEY_COLUMN.key(), this.inventoryDatabase.getDatabaseName() + ".multi_max_\\.*:order_id;" + this.inventoryDatabase.getDatabaseName() + ".products:id;");
        MockContext context = new MockContext(Configuration.fromMap(options));
        MySqlDataSourceFactory factory = new MySqlDataSourceFactory();
        MySqlDataSource dataSource = (MySqlDataSource)factory.createDataSource((Factory.Context)context);
        final ObjectPath multiMaxTable = new ObjectPath(this.inventoryDatabase.getDatabaseName(), "multi_max_table");
        final ObjectPath productsTable = new ObjectPath(this.inventoryDatabase.getDatabaseName(), "products");
        ((MapAssert)Assertions.assertThat((Map)dataSource.getSourceConfig().getChunkKeyColumns()).isNotEmpty()).isEqualTo((Object)new HashMap<ObjectPath, String>(){
            {
                this.put(multiMaxTable, "order_id");
                this.put(productsTable, "id");
            }
        });
    }

    class MockContext
    implements Factory.Context {
        Configuration factoryConfiguration;

        public MockContext(Configuration factoryConfiguration) {
            this.factoryConfiguration = factoryConfiguration;
        }

        public Configuration getFactoryConfiguration() {
            return this.factoryConfiguration;
        }

        public Configuration getPipelineConfiguration() {
            return null;
        }

        public ClassLoader getClassLoader() {
            return this.getClassLoader();
        }
    }
}

