/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.composer.definition;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.configuration.Configuration;
import org.apache.flink.cdc.common.event.SchemaChangeEventType;
import org.apache.flink.cdc.common.event.SchemaChangeEventTypeFamily;

public class SinkDef {
    private final String type;
    @Nullable
    private final String name;
    private final Configuration config;
    private final Set<SchemaChangeEventType> includedSchemaEvolutionTypes;

    public SinkDef(String type, @Nullable String name, Configuration config) {
        this.type = type;
        this.name = name;
        this.config = config;
        this.includedSchemaEvolutionTypes = Arrays.stream(SchemaChangeEventTypeFamily.ALL).collect(Collectors.toSet());
    }

    public SinkDef(String type, @Nullable String name, Configuration config, Set<SchemaChangeEventType> includedSchemaEvolutionTypes) {
        this.type = type;
        this.name = name;
        this.config = config;
        this.includedSchemaEvolutionTypes = includedSchemaEvolutionTypes;
    }

    public String getType() {
        return this.type;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public Configuration getConfig() {
        return this.config;
    }

    public Set<SchemaChangeEventType> getIncludedSchemaEvolutionTypes() {
        return this.includedSchemaEvolutionTypes;
    }

    public String toString() {
        return "SinkDef{type='" + this.type + '\'' + ", name='" + this.name + '\'' + ", config=" + this.config + ", includedSchemaEvolutionTypes=" + this.includedSchemaEvolutionTypes + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SinkDef sinkDef = (SinkDef)o;
        return Objects.equals(this.type, sinkDef.type) && Objects.equals(this.name, sinkDef.name) && Objects.equals(this.config, sinkDef.config) && Objects.equals(this.includedSchemaEvolutionTypes, sinkDef.includedSchemaEvolutionTypes);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.config, this.includedSchemaEvolutionTypes);
    }
}

