/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.composer.utils;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.factories.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class FactoryDiscoveryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FactoryDiscoveryUtils.class);

    private FactoryDiscoveryUtils() {
    }

    public static <T extends Factory> T getFactoryByIdentifier(String identifier, Class<T> factoryClass) {
        ServiceLoader<Factory> loader = ServiceLoader.load(Factory.class);
        ArrayList<Factory> factoryList = new ArrayList<Factory>();
        for (Factory factory : loader) {
            if (factory == null || !factory.identifier().equals(identifier) || !factoryClass.isAssignableFrom(factory.getClass())) continue;
            factoryList.add(factory);
        }
        if (factoryList.isEmpty()) {
            throw new RuntimeException(String.format("Cannot find factory with identifier \"%s\" in the classpath.\n\nAvailable factory classes are:\n\n%s", identifier, StreamSupport.stream(loader.spliterator(), false).map(f -> f.getClass().getName()).sorted().collect(Collectors.joining("\n"))));
        }
        if (factoryList.size() > 1) {
            throw new RuntimeException(String.format("Multiple factories found in the classpath.\n\nAmbiguous factory classes are:\n\n%s", factoryList.stream().map(f -> f.getClass().getName()).sorted().collect(Collectors.joining("\n"))));
        }
        return (T)((Factory)factoryList.get(0));
    }

    public static <T extends Factory> Optional<URL> getJarPathByIdentifier(String identifier, Class<T> factoryClass) {
        try {
            T factory = FactoryDiscoveryUtils.getFactoryByIdentifier(identifier, factoryClass);
            URL url = factory.getClass().getProtectionDomain().getCodeSource().getLocation();
            if (Files.isDirectory(Paths.get(url.toURI()), new LinkOption[0])) {
                LOG.warn("The factory class \"{}\" is contained by directory \"{}\" instead of JAR. This might happen in integration test. Will ignore the directory.", (Object)factory.getClass().getCanonicalName(), (Object)url);
                return Optional.empty();
            }
            return Optional.of(url);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to search JAR by factory identifier \"%s\"", identifier));
        }
    }
}

