/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.types;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypeRoot;
import org.apache.flink.cdc.common.types.DataTypeVisitor;
import org.apache.flink.cdc.common.utils.Preconditions;

@PublicEvolving
public final class ArrayType
extends DataType {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT = "ARRAY<%s>";
    private final DataType elementType;

    public ArrayType(boolean isNullable, DataType elementType) {
        super(isNullable, DataTypeRoot.ARRAY);
        this.elementType = Preconditions.checkNotNull(elementType, "Element type must not be null.");
    }

    public ArrayType(DataType elementType) {
        this(true, elementType);
    }

    public DataType getElementType() {
        return this.elementType;
    }

    @Override
    public DataType copy(boolean isNullable) {
        return new ArrayType(isNullable, this.elementType.copy());
    }

    @Override
    public String asSummaryString() {
        return this.withNullability(FORMAT, this.elementType.asSummaryString());
    }

    @Override
    public String asSerializableString() {
        return this.withNullability(FORMAT, this.elementType.asSerializableString());
    }

    @Override
    public List<DataType> getChildren() {
        return Collections.singletonList(this.elementType);
    }

    @Override
    public <R> R accept(DataTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayType arrayType = (ArrayType)o;
        return this.elementType.equals(arrayType.elementType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementType);
    }
}

