/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.event;

import java.util.List;
import java.util.Objects;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEventType;
import org.apache.flink.cdc.common.event.TableId;

@PublicEvolving
public class DropColumnEvent
implements SchemaChangeEvent {
    private static final long serialVersionUID = 1L;
    private final TableId tableId;
    private final List<String> droppedColumnNames;

    public DropColumnEvent(TableId tableId, List<String> droppedColumnNames) {
        this.tableId = tableId;
        this.droppedColumnNames = droppedColumnNames;
    }

    public List<String> getDroppedColumnNames() {
        return this.droppedColumnNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DropColumnEvent)) {
            return false;
        }
        DropColumnEvent that = (DropColumnEvent)o;
        return Objects.equals(this.tableId, that.tableId) && Objects.equals(this.droppedColumnNames, that.droppedColumnNames);
    }

    public int hashCode() {
        return Objects.hash(this.tableId, this.droppedColumnNames);
    }

    public String toString() {
        return "DropColumnEvent{tableId=" + this.tableId + ", droppedColumnNames=" + this.droppedColumnNames + '}';
    }

    @Override
    public TableId tableId() {
        return this.tableId;
    }

    @Override
    public SchemaChangeEventType getType() {
        return SchemaChangeEventType.DROP_COLUMN;
    }
}

