/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.event;

import java.util.Map;
import java.util.Objects;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEventType;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.types.DataType;

public class AlterColumnTypeEvent
implements SchemaChangeEvent {
    private static final long serialVersionUID = 1L;
    private final TableId tableId;
    private final Map<String, DataType> typeMapping;

    public AlterColumnTypeEvent(TableId tableId, Map<String, DataType> typeMapping) {
        this.tableId = tableId;
        this.typeMapping = typeMapping;
    }

    public Map<String, DataType> getTypeMapping() {
        return this.typeMapping;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlterColumnTypeEvent)) {
            return false;
        }
        AlterColumnTypeEvent that = (AlterColumnTypeEvent)o;
        return Objects.equals(this.tableId, that.tableId) && Objects.equals(this.typeMapping, that.typeMapping);
    }

    public int hashCode() {
        return Objects.hash(this.tableId, this.typeMapping);
    }

    public String toString() {
        return "AlterColumnTypeEvent{tableId=" + this.tableId + ", nameMapping=" + this.typeMapping + '}';
    }

    @Override
    public TableId tableId() {
        return this.tableId;
    }

    @Override
    public SchemaChangeEventType getType() {
        return SchemaChangeEventType.ALTER_COLUMN_TYPE;
    }
}

