/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.net;

import com.sun.istack.Nullable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.apache.flink.fs.azure.shaded.com.google.common.net.InetAddresses;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class DNS {
    private static final Logger LOG = LoggerFactory.getLogger(DNS.class);
    private static final String cachedHostname = DNS.resolveLocalHostname();
    private static final String cachedHostAddress = DNS.resolveLocalHostIPAddress();
    private static final String LOCALHOST = "localhost";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String reverseDns(InetAddress hostIp, @Nullable String ns) throws NamingException {
        Attributes attribute;
        String[] parts = hostIp.getHostAddress().split("\\.");
        String reverseIP = parts[3] + "." + parts[2] + "." + parts[1] + "." + parts[0] + ".in-addr.arpa";
        try (InitialDirContext ictx = new InitialDirContext();){
            attribute = ictx.getAttributes("dns://" + (ns == null ? "" : ns) + "/" + reverseIP, new String[]{"PTR"});
        }
        String hostname = attribute.get("PTR").get().toString();
        int hostnameLength = hostname.length();
        if (hostname.charAt(hostnameLength - 1) == '.') {
            hostname = hostname.substring(0, hostnameLength - 1);
        }
        return hostname;
    }

    private static NetworkInterface getSubinterface(String strInterface) throws SocketException {
        Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
        while (nifs.hasMoreElements()) {
            Enumeration<NetworkInterface> subNifs = nifs.nextElement().getSubInterfaces();
            while (subNifs.hasMoreElements()) {
                NetworkInterface nif = subNifs.nextElement();
                if (!nif.getName().equals(strInterface)) continue;
                return nif;
            }
        }
        return null;
    }

    private static LinkedHashSet<InetAddress> getSubinterfaceInetAddrs(NetworkInterface nif) {
        LinkedHashSet<InetAddress> addrs = new LinkedHashSet<InetAddress>();
        Enumeration<NetworkInterface> subNifs = nif.getSubInterfaces();
        while (subNifs.hasMoreElements()) {
            NetworkInterface subNif = subNifs.nextElement();
            addrs.addAll(Collections.list(subNif.getInetAddresses()));
        }
        return addrs;
    }

    public static String[] getIPs(String strInterface) throws UnknownHostException {
        return DNS.getIPs(strInterface, true);
    }

    public static String[] getIPs(String strInterface, boolean returnSubinterfaces) throws UnknownHostException {
        NetworkInterface netIf;
        if ("default".equals(strInterface)) {
            return new String[]{cachedHostAddress};
        }
        try {
            netIf = NetworkInterface.getByName(strInterface);
            if (netIf == null) {
                netIf = DNS.getSubinterface(strInterface);
            }
        }
        catch (SocketException e) {
            LOG.warn("I/O error finding interface {}", (Object)strInterface, (Object)e);
            return new String[]{cachedHostAddress};
        }
        if (netIf == null) {
            throw new UnknownHostException("No such interface " + strInterface);
        }
        LinkedHashSet<InetAddress> allAddrs = new LinkedHashSet<InetAddress>();
        allAddrs.addAll(Collections.list(netIf.getInetAddresses()));
        if (!returnSubinterfaces) {
            allAddrs.removeAll(DNS.getSubinterfaceInetAddrs(netIf));
        }
        String[] ips = new String[allAddrs.size()];
        int i = 0;
        for (InetAddress addr : allAddrs) {
            ips[i++] = addr.getHostAddress();
        }
        return ips;
    }

    public static String getDefaultIP(String strInterface) throws UnknownHostException {
        String[] ips = DNS.getIPs(strInterface);
        return ips[0];
    }

    public static String[] getHosts(String strInterface, @Nullable String nameserver, boolean tryfallbackResolution) throws UnknownHostException {
        Vector<String> hosts = new Vector<String>();
        List<InetAddress> addresses = DNS.getIPsAsInetAddressList(strInterface, true);
        for (InetAddress address : addresses) {
            try {
                hosts.add(DNS.reverseDns(address, nameserver));
            }
            catch (NamingException namingException) {}
        }
        if (hosts.isEmpty() && tryfallbackResolution) {
            for (InetAddress address : addresses) {
                String canonicalHostName = address.getCanonicalHostName();
                if (InetAddresses.isInetAddress(canonicalHostName)) continue;
                hosts.add(canonicalHostName);
            }
        }
        if (hosts.isEmpty()) {
            LOG.warn("Unable to determine hostname for interface {}", (Object)strInterface);
            hosts.add(cachedHostname);
        }
        return hosts.toArray(new String[hosts.size()]);
    }

    private static String resolveLocalHostname() {
        String localhost;
        try {
            localhost = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            LOG.warn("Unable to determine local hostname -falling back to '{}'", (Object)LOCALHOST, (Object)e);
            localhost = LOCALHOST;
        }
        return localhost;
    }

    private static String resolveLocalHostIPAddress() {
        String address;
        try {
            address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOG.warn("Unable to determine address of the host -falling back to '{}' address", (Object)LOCALHOST, (Object)e);
            try {
                address = InetAddress.getByName(LOCALHOST).getHostAddress();
            }
            catch (UnknownHostException noLocalHostAddressException) {
                LOG.error("Unable to determine local loopback address of '{}' -this system's network configuration is unsupported", (Object)LOCALHOST, (Object)e);
                address = null;
            }
        }
        return address;
    }

    public static String[] getHosts(String strInterface) throws UnknownHostException {
        return DNS.getHosts(strInterface, null, false);
    }

    public static String getDefaultHost(@Nullable String strInterface, @Nullable String nameserver, boolean tryfallbackResolution) throws UnknownHostException {
        if (strInterface == null || "default".equals(strInterface)) {
            return cachedHostname;
        }
        if (nameserver != null && "default".equals(nameserver)) {
            nameserver = null;
        }
        String[] hosts = DNS.getHosts(strInterface, nameserver, tryfallbackResolution);
        return hosts[0];
    }

    public static String getDefaultHost(@Nullable String strInterface) throws UnknownHostException {
        return DNS.getDefaultHost(strInterface, null, false);
    }

    public static String getDefaultHost(@Nullable String strInterface, @Nullable String nameserver) throws UnknownHostException {
        return DNS.getDefaultHost(strInterface, nameserver, false);
    }

    public static List<InetAddress> getIPsAsInetAddressList(String strInterface, boolean returnSubinterfaces) throws UnknownHostException {
        NetworkInterface netIf;
        if ("default".equals(strInterface)) {
            return Arrays.asList(InetAddress.getByName(cachedHostAddress));
        }
        try {
            netIf = NetworkInterface.getByName(strInterface);
            if (netIf == null) {
                netIf = DNS.getSubinterface(strInterface);
            }
        }
        catch (SocketException e) {
            LOG.warn("I/O error finding interface {}: {}", (Object)strInterface, (Object)e.getMessage());
            return Arrays.asList(InetAddress.getByName(cachedHostAddress));
        }
        if (netIf == null) {
            throw new UnknownHostException("No such interface " + strInterface);
        }
        LinkedHashSet<InetAddress> allAddrs = new LinkedHashSet<InetAddress>();
        allAddrs.addAll(Collections.list(netIf.getInetAddresses()));
        if (!returnSubinterfaces) {
            allAddrs.removeAll(DNS.getSubinterfaceInetAddrs(netIf));
        }
        return new Vector<InetAddress>(allAddrs);
    }
}

