/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.com.fasterxml.jackson.databind.deser;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.flink.fs.shaded.hadoop3.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.fs.shaded.hadoop3.com.fasterxml.jackson.core.JsonToken;
import org.apache.flink.fs.shaded.hadoop3.com.fasterxml.jackson.databind.BeanDescription;
import org.apache.flink.fs.shaded.hadoop3.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.fs.shaded.hadoop3.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.fs.shaded.hadoop3.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.fs.shaded.hadoop3.com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import org.apache.flink.fs.shaded.hadoop3.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import org.apache.flink.fs.shaded.hadoop3.com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import org.apache.flink.fs.shaded.hadoop3.com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import org.apache.flink.fs.shaded.hadoop3.com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import org.apache.flink.fs.shaded.hadoop3.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;

public class AbstractDeserializer
extends JsonDeserializer<Object>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final JavaType _baseType;
    protected final ObjectIdReader _objectIdReader;
    protected final Map<String, SettableBeanProperty> _backRefProperties;
    protected final boolean _acceptString;
    protected final boolean _acceptBoolean;
    protected final boolean _acceptInt;
    protected final boolean _acceptDouble;

    public AbstractDeserializer(BeanDeserializerBuilder builder, BeanDescription beanDesc, Map<String, SettableBeanProperty> backRefProps) {
        this._baseType = beanDesc.getType();
        this._objectIdReader = builder.getObjectIdReader();
        this._backRefProperties = backRefProps;
        Class<Object> cls = this._baseType.getRawClass();
        this._acceptString = cls.isAssignableFrom(String.class);
        this._acceptBoolean = cls == Boolean.TYPE || cls.isAssignableFrom(Boolean.class);
        this._acceptInt = cls == Integer.TYPE || cls.isAssignableFrom(Integer.class);
        this._acceptDouble = cls == Double.TYPE || cls.isAssignableFrom(Double.class);
    }

    protected AbstractDeserializer(BeanDescription beanDesc) {
        this._baseType = beanDesc.getType();
        this._objectIdReader = null;
        this._backRefProperties = null;
        Class<Object> cls = this._baseType.getRawClass();
        this._acceptString = cls.isAssignableFrom(String.class);
        this._acceptBoolean = cls == Boolean.TYPE || cls.isAssignableFrom(Boolean.class);
        this._acceptInt = cls == Integer.TYPE || cls.isAssignableFrom(Integer.class);
        this._acceptDouble = cls == Double.TYPE || cls.isAssignableFrom(Double.class);
    }

    public static AbstractDeserializer constructForNonPOJO(BeanDescription beanDesc) {
        return new AbstractDeserializer(beanDesc);
    }

    @Override
    public Class<?> handledType() {
        return this._baseType.getRawClass();
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public ObjectIdReader getObjectIdReader() {
        return this._objectIdReader;
    }

    @Override
    public SettableBeanProperty findBackReference(String logicalName) {
        return this._backRefProperties == null ? null : this._backRefProperties.get(logicalName);
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        Object result;
        JsonToken t;
        if (this._objectIdReader != null && (t = p.getCurrentToken()) != null) {
            if (t.isScalarValue()) {
                return this._deserializeFromObjectId(p, ctxt);
            }
            if (t == JsonToken.START_OBJECT) {
                t = p.nextToken();
            }
            if (t == JsonToken.FIELD_NAME && this._objectIdReader.maySerializeAsObject() && this._objectIdReader.isValidReferencePropertyName(p.getCurrentName(), p)) {
                return this._deserializeFromObjectId(p, ctxt);
            }
        }
        if ((result = this._deserializeIfNatural(p, ctxt)) != null) {
            return result;
        }
        return typeDeserializer.deserializeTypedFromObject(p, ctxt);
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        throw ctxt.instantiationException(this._baseType.getRawClass(), "abstract types either need to be mapped to concrete types, have custom deserializer, or be instantiated with additional type information");
    }

    protected Object _deserializeIfNatural(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.getCurrentTokenId()) {
            case 6: {
                if (!this._acceptString) break;
                return p.getText();
            }
            case 7: {
                if (!this._acceptInt) break;
                return p.getIntValue();
            }
            case 8: {
                if (!this._acceptDouble) break;
                return p.getDoubleValue();
            }
            case 9: {
                if (!this._acceptBoolean) break;
                return Boolean.TRUE;
            }
            case 10: {
                if (!this._acceptBoolean) break;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected Object _deserializeFromObjectId(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object id = this._objectIdReader.readObjectReference(p, ctxt);
        ReadableObjectId roid = ctxt.findObjectId(id, this._objectIdReader.generator, this._objectIdReader.resolver);
        Object pojo = roid.resolve();
        if (pojo == null) {
            throw new UnresolvedForwardReference(p, "Could not resolve Object Id [" + id + "] -- unresolved forward-reference?", p.getCurrentLocation(), roid);
        }
        return pojo;
    }
}

