/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage;

import java.net.URI;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.OperationContext;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageCredentials;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageUri;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.Base64;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.Utility;

public final class StorageCredentialsAccountAndKey
extends StorageCredentials {
    private String accountName;
    private Mac hmacSha256;
    private byte[] key;

    public StorageCredentialsAccountAndKey(String accountName, byte[] key) {
        if (Utility.isNullOrEmptyOrWhitespace(accountName)) {
            throw new IllegalArgumentException("Invalid account name.");
        }
        if (key == null || key.length == 0) {
            throw new IllegalArgumentException("Storage Key is not a valid base64 encoded string.");
        }
        this.accountName = accountName;
        this.key = key;
    }

    public StorageCredentialsAccountAndKey(String accountName, String key) {
        this(accountName, Base64.decode(key));
    }

    @Override
    public String getAccountName() {
        return this.accountName;
    }

    public String exportBase64EncodedKey() {
        return Base64.encode(this.key);
    }

    public byte[] exportKey() {
        byte[] copy = (byte[])this.key.clone();
        return copy;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public synchronized void updateKey(String key) {
        this.updateKey(Base64.decode(key));
    }

    public synchronized void updateKey(byte[] key) {
        if (key == null || key.length == 0) {
            throw new IllegalArgumentException("Storage Key is not a valid base64 encoded string.");
        }
        this.key = key;
        this.hmacSha256 = null;
    }

    @Override
    public String toString(boolean exportSecrets) {
        return String.format("%s=%s;%s=%s", "AccountName", this.getAccountName(), "AccountKey", exportSecrets ? this.exportBase64EncodedKey() : "[key hidden]");
    }

    @Override
    public URI transformUri(URI resourceUri, OperationContext opContext) {
        return resourceUri;
    }

    @Override
    public StorageUri transformUri(StorageUri resourceUri, OperationContext opContext) {
        return resourceUri;
    }

    public synchronized Mac getHmac256() throws InvalidKeyException {
        if (this.hmacSha256 == null) {
            try {
                this.hmacSha256 = Mac.getInstance("HmacSHA256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException();
            }
            this.hmacSha256.init(new SecretKeySpec(this.key, "HmacSHA256"));
        }
        return this.hmacSha256;
    }
}

