/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.security;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.SecureWasbRemoteCallHelper;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.WasbRemoteCallHelper;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.security.JsonUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.security.TokenUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.security.WasbDelegationTokenManager;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.Text;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.retry.RetryUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.token.Token;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.http.client.utils.URIBuilder;

public class RemoteWasbDelegationTokenManager
implements WasbDelegationTokenManager {
    public static final String KEY_DELEGATION_TOKEN_SERVICE_URLS = "fs.azure.delegation.token.service.urls";
    public static final String DT_MANAGER_HTTP_CLIENT_RETRY_POLICY_ENABLED_KEY = "fs.azure.delegationtokenservice.http.retry.policy.enabled";
    public static final String DT_MANAGER_HTTP_CLIENT_RETRY_POLICY_SPEC_KEY = "fs.azure.delegationtokenservice.http.retry.policy.spec";
    private static final String DEFAULT_DELEGATION_TOKEN_MANAGER_ENDPOINT = "/tokenmanager/v1";
    private static final String DT_MANAGER_HTTP_CLIENT_RETRY_POLICY_SPEC_DEFAULT = "10,3,100,2";
    private static final boolean DT_MANAGER_HTTP_CLIENT_RETRY_POLICY_ENABLED_DEFAULT = true;
    private static final Text WASB_DT_SERVICE_NAME = new Text("WASB_DT_SERVICE");
    private static final String GET_DELEGATION_TOKEN_OP = "GETDELEGATIONTOKEN";
    private static final String RENEW_DELEGATION_TOKEN_OP = "RENEWDELEGATIONTOKEN";
    private static final String CANCEL_DELEGATION_TOKEN_OP = "CANCELDELEGATIONTOKEN";
    private static final String OP_PARAM_KEY_NAME = "op";
    private static final String RENEWER_PARAM_KEY_NAME = "renewer";
    private static final String SERVICE_PARAM_KEY_NAME = "service";
    private static final String TOKEN_PARAM_KEY_NAME = "token";
    private WasbRemoteCallHelper remoteCallHelper;
    private String[] dtServiceUrls;
    private boolean isSpnegoTokenCacheEnabled;

    public RemoteWasbDelegationTokenManager(Configuration conf) throws IOException {
        RetryPolicy retryPolicy = RetryUtils.getMultipleLinearRandomRetry(conf, DT_MANAGER_HTTP_CLIENT_RETRY_POLICY_ENABLED_KEY, true, DT_MANAGER_HTTP_CLIENT_RETRY_POLICY_SPEC_KEY, DT_MANAGER_HTTP_CLIENT_RETRY_POLICY_SPEC_DEFAULT);
        this.isSpnegoTokenCacheEnabled = conf.getBoolean("fs.azure.enable.spnego.token.cache", true);
        this.remoteCallHelper = new SecureWasbRemoteCallHelper(retryPolicy, true, this.isSpnegoTokenCacheEnabled);
        this.dtServiceUrls = conf.getTrimmedStrings(KEY_DELEGATION_TOKEN_SERVICE_URLS);
        if (this.dtServiceUrls == null || this.dtServiceUrls.length <= 0) {
            throw new IOException("fs.azure.delegation.token.service.urls config not set in configuration.");
        }
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        URIBuilder uriBuilder = new URIBuilder().setPath(DEFAULT_DELEGATION_TOKEN_MANAGER_ENDPOINT).addParameter(OP_PARAM_KEY_NAME, GET_DELEGATION_TOKEN_OP).addParameter(RENEWER_PARAM_KEY_NAME, renewer).addParameter(SERVICE_PARAM_KEY_NAME, WASB_DT_SERVICE_NAME.toString());
        String responseBody = this.remoteCallHelper.makeRemoteRequest(this.dtServiceUrls, uriBuilder.getPath(), uriBuilder.getQueryParams(), "GET");
        return TokenUtils.toDelegationToken(JsonUtils.parse(responseBody));
    }

    @Override
    public long renewDelegationToken(Token<?> token) throws IOException {
        URIBuilder uriBuilder = new URIBuilder().setPath(DEFAULT_DELEGATION_TOKEN_MANAGER_ENDPOINT).addParameter(OP_PARAM_KEY_NAME, RENEW_DELEGATION_TOKEN_OP).addParameter(TOKEN_PARAM_KEY_NAME, token.encodeToUrlString());
        String responseBody = this.remoteCallHelper.makeRemoteRequest(this.dtServiceUrls, uriBuilder.getPath(), uriBuilder.getQueryParams(), "PUT");
        Map<?, ?> parsedResp = JsonUtils.parse(responseBody);
        return ((Number)parsedResp.get("long")).longValue();
    }

    @Override
    public void cancelDelegationToken(Token<?> token) throws IOException {
        URIBuilder uriBuilder = new URIBuilder().setPath(DEFAULT_DELEGATION_TOKEN_MANAGER_ENDPOINT).addParameter(OP_PARAM_KEY_NAME, CANCEL_DELEGATION_TOKEN_OP).addParameter(TOKEN_PARAM_KEY_NAME, token.encodeToUrlString());
        this.remoteCallHelper.makeRemoteRequest(this.dtServiceUrls, uriBuilder.getPath(), uriBuilder.getQueryParams(), "PUT");
    }
}

