/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.logging.Log;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configurable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.DataInputBuffer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.DataOutputBuffer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.Writable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.serializer.Deserializer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.serializer.Serializer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.Time;
import org.slf4j.Logger;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ReflectionUtils {
    private static final Class<?>[] EMPTY_ARRAY = new Class[0];
    private static volatile SerializationFactory serialFactory = null;
    private static final Map<Class<?>, Constructor<?>> CONSTRUCTOR_CACHE = new ConcurrentHashMap();
    private static ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    private static long previousLogTime = 0L;
    private static final ThreadLocal<CopyInCopyOutBuffer> CLONE_BUFFERS = new ThreadLocal<CopyInCopyOutBuffer>(){

        @Override
        protected synchronized CopyInCopyOutBuffer initialValue() {
            return new CopyInCopyOutBuffer();
        }
    };

    public static void setConf(Object theObject, Configuration conf) {
        if (conf != null) {
            if (theObject instanceof Configurable) {
                ((Configurable)theObject).setConf(conf);
            }
            ReflectionUtils.setJobConf(theObject, conf);
        }
    }

    private static void setJobConf(Object theObject, Configuration conf) {
        try {
            Class<?> jobConfClass = conf.getClassByNameOrNull("org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.mapred.JobConf");
            if (jobConfClass == null) {
                return;
            }
            Class<?> jobConfigurableClass = conf.getClassByNameOrNull("org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.mapred.JobConfigurable");
            if (jobConfigurableClass == null) {
                return;
            }
            if (jobConfClass.isAssignableFrom(conf.getClass()) && jobConfigurableClass.isAssignableFrom(theObject.getClass())) {
                Method configureMethod = jobConfigurableClass.getMethod("configure", jobConfClass);
                configureMethod.invoke(theObject, conf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error in configuring object", e);
        }
    }

    public static <T> T newInstance(Class<T> theClass, Configuration conf) {
        Object result;
        try {
            Constructor<Object> meth = CONSTRUCTOR_CACHE.get(theClass);
            if (meth == null) {
                meth = theClass.getDeclaredConstructor(EMPTY_ARRAY);
                meth.setAccessible(true);
                CONSTRUCTOR_CACHE.put(theClass, meth);
            }
            result = meth.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ReflectionUtils.setConf(result, conf);
        return (T)result;
    }

    public static void setContentionTracing(boolean val) {
        threadBean.setThreadContentionMonitoringEnabled(val);
    }

    private static String getTaskName(long id, String name) {
        if (name == null) {
            return Long.toString(id);
        }
        return id + " (" + name + ")";
    }

    public static synchronized void printThreadInfo(PrintStream stream, String title) {
        int STACK_DEPTH = 20;
        boolean contention = threadBean.isThreadContentionMonitoringEnabled();
        long[] threadIds = threadBean.getAllThreadIds();
        stream.println("Process Thread Dump: " + title);
        stream.println(threadIds.length + " active threads");
        for (long tid : threadIds) {
            ThreadInfo info = threadBean.getThreadInfo(tid, 20);
            if (info == null) {
                stream.println("  Inactive");
                continue;
            }
            stream.println("Thread " + ReflectionUtils.getTaskName(info.getThreadId(), info.getThreadName()) + ":");
            Thread.State state = info.getThreadState();
            stream.println("  State: " + (Object)((Object)state));
            stream.println("  Blocked count: " + info.getBlockedCount());
            stream.println("  Waited count: " + info.getWaitedCount());
            if (contention) {
                stream.println("  Blocked time: " + info.getBlockedTime());
                stream.println("  Waited time: " + info.getWaitedTime());
            }
            if (state == Thread.State.WAITING) {
                stream.println("  Waiting on " + info.getLockName());
            } else if (state == Thread.State.BLOCKED) {
                stream.println("  Blocked on " + info.getLockName());
                stream.println("  Blocked by " + ReflectionUtils.getTaskName(info.getLockOwnerId(), info.getLockOwnerName()));
            }
            stream.println("  Stack:");
            for (StackTraceElement frame : info.getStackTrace()) {
                stream.println("    " + frame.toString());
            }
        }
        stream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void logThreadInfo(Log log, String title, long minInterval) {
        boolean dumpStack = false;
        if (!log.isInfoEnabled()) return;
        Class<ReflectionUtils> clazz = ReflectionUtils.class;
        synchronized (ReflectionUtils.class) {
            long now = Time.monotonicNow();
            if (now - previousLogTime >= minInterval * 1000L) {
                previousLogTime = now;
                dumpStack = true;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (!dumpStack) return;
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                ReflectionUtils.printThreadInfo(new PrintStream((OutputStream)buffer, false, "UTF-8"), title);
                log.info(buffer.toString(Charset.defaultCharset().name()));
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void logThreadInfo(Logger log, String title, long minInterval) {
        boolean dumpStack = false;
        if (!log.isInfoEnabled()) return;
        Class<ReflectionUtils> clazz = ReflectionUtils.class;
        synchronized (ReflectionUtils.class) {
            long now = Time.monotonicNow();
            if (now - previousLogTime >= minInterval * 1000L) {
                previousLogTime = now;
                dumpStack = true;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (!dumpStack) return;
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                ReflectionUtils.printThreadInfo(new PrintStream((OutputStream)buffer, false, "UTF-8"), title);
                log.info(buffer.toString(Charset.defaultCharset().name()));
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return;
        }
    }

    public static <T> Class<T> getClass(T o) {
        return o.getClass();
    }

    static void clearCache() {
        CONSTRUCTOR_CACHE.clear();
    }

    static int getCacheSize() {
        return CONSTRUCTOR_CACHE.size();
    }

    private static SerializationFactory getFactory(Configuration conf) {
        if (serialFactory == null) {
            serialFactory = new SerializationFactory(conf);
        }
        return serialFactory;
    }

    public static <T> T copy(Configuration conf, T src, T dst) throws IOException {
        CopyInCopyOutBuffer buffer = CLONE_BUFFERS.get();
        buffer.outBuffer.reset();
        SerializationFactory factory = ReflectionUtils.getFactory(conf);
        Class<?> cls = src.getClass();
        Serializer<?> serializer = factory.getSerializer(cls);
        serializer.open(buffer.outBuffer);
        serializer.serialize(src);
        buffer.moveData();
        Deserializer<?> deserializer = factory.getDeserializer(cls);
        deserializer.open(buffer.inBuffer);
        dst = deserializer.deserialize(dst);
        return dst;
    }

    @Deprecated
    public static void cloneWritableInto(Writable dst, Writable src) throws IOException {
        CopyInCopyOutBuffer buffer = CLONE_BUFFERS.get();
        buffer.outBuffer.reset();
        src.write(buffer.outBuffer);
        buffer.moveData();
        dst.readFields(buffer.inBuffer);
    }

    public static List<Field> getDeclaredFieldsIncludingInherited(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            Field[] sortedFields = clazz.getDeclaredFields();
            Arrays.sort(sortedFields, new Comparator<Field>(){

                @Override
                public int compare(Field a, Field b) {
                    return a.getName().compareTo(b.getName());
                }
            });
            for (Field field : sortedFields) {
                fields.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static List<Method> getDeclaredMethodsIncludingInherited(Class<?> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        while (clazz != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                methods.add(method);
            }
            clazz = clazz.getSuperclass();
        }
        return methods;
    }

    private static class CopyInCopyOutBuffer {
        DataOutputBuffer outBuffer = new DataOutputBuffer();
        DataInputBuffer inBuffer = new DataInputBuffer();

        private CopyInCopyOutBuffer() {
        }

        void moveData() {
            this.inBuffer.reset(this.outBuffer.getData(), this.outBuffer.getLength());
        }
    }
}

