/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.alias;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.permission.FsPermission;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.alias.AbstractJavaKeyStoreProvider;

@InterfaceAudience.Private
public abstract class KeyStoreProvider
extends AbstractJavaKeyStoreProvider {
    private FileSystem fs;
    private FsPermission permissions;

    protected KeyStoreProvider(URI uri, Configuration conf) throws IOException {
        super(uri, conf);
    }

    @Override
    protected OutputStream getOutputStreamForKeystore() throws IOException {
        FSDataOutputStream out = FileSystem.create(this.fs, this.getPath(), this.permissions);
        return out;
    }

    @Override
    protected boolean keystoreExists() throws IOException {
        return this.fs.exists(this.getPath());
    }

    @Override
    protected InputStream getInputStreamForFile() throws IOException {
        return this.fs.open(this.getPath());
    }

    @Override
    protected void createPermissions(String perms) {
        this.permissions = new FsPermission(perms);
    }

    @Override
    protected void stashOriginalFilePermissions() throws IOException {
        FileStatus s2 = this.fs.getFileStatus(this.getPath());
        this.permissions = s2.getPermission();
    }

    @Override
    protected void initFileSystem(URI uri) throws IOException {
        super.initFileSystem(uri);
        this.fs = this.getPath().getFileSystem(this.getConf());
    }
}

